<?php //809e8e752e0f27588fbb4459fd633171
/** @noinspection all */

namespace App\Models {

    use Database\Factories\PageFactory;
    use Database\Factories\UserFactory;
    use Illuminate\Database\Eloquent\Model;
    use Illuminate\Database\Eloquent\Relations\BelongsTo;
    use Illuminate\Database\Eloquent\Relations\HasMany;
    use Illuminate\Database\Eloquent\Relations\HasOne;
    use Illuminate\Database\Eloquent\Relations\MorphToMany;
    use Illuminate\Notifications\DatabaseNotification;
    use Illuminate\Notifications\DatabaseNotificationCollection;
    use Illuminate\Support\Carbon;
    use LaravelIdea\Helper\App\Models\_IH_ContactMessage_C;
    use LaravelIdea\Helper\App\Models\_IH_ContactMessage_QB;
    use LaravelIdea\Helper\App\Models\_IH_CrawlRequest_C;
    use LaravelIdea\Helper\App\Models\_IH_CrawlRequest_QB;
    use LaravelIdea\Helper\App\Models\_IH_DomainFeed_C;
    use LaravelIdea\Helper\App\Models\_IH_DomainFeed_QB;
    use LaravelIdea\Helper\App\Models\_IH_DomainIcon_C;
    use LaravelIdea\Helper\App\Models\_IH_DomainIcon_QB;
    use LaravelIdea\Helper\App\Models\_IH_DomainSitemap_C;
    use LaravelIdea\Helper\App\Models\_IH_DomainSitemap_QB;
    use LaravelIdea\Helper\App\Models\_IH_Domain_C;
    use LaravelIdea\Helper\App\Models\_IH_Domain_QB;
    use LaravelIdea\Helper\App\Models\_IH_Image_C;
    use LaravelIdea\Helper\App\Models\_IH_Image_QB;
    use LaravelIdea\Helper\App\Models\_IH_Link_C;
    use LaravelIdea\Helper\App\Models\_IH_Link_QB;
    use LaravelIdea\Helper\App\Models\_IH_PageBody_C;
    use LaravelIdea\Helper\App\Models\_IH_PageBody_QB;
    use LaravelIdea\Helper\App\Models\_IH_PageRank_C;
    use LaravelIdea\Helper\App\Models\_IH_PageRank_QB;
    use LaravelIdea\Helper\App\Models\_IH_Page_C;
    use LaravelIdea\Helper\App\Models\_IH_Page_QB;
    use LaravelIdea\Helper\App\Models\_IH_SearchLog_C;
    use LaravelIdea\Helper\App\Models\_IH_SearchLog_QB;
    use LaravelIdea\Helper\App\Models\_IH_Setting_C;
    use LaravelIdea\Helper\App\Models\_IH_Setting_QB;
    use LaravelIdea\Helper\App\Models\_IH_Snapshot_C;
    use LaravelIdea\Helper\App\Models\_IH_Snapshot_QB;
    use LaravelIdea\Helper\App\Models\_IH_User_C;
    use LaravelIdea\Helper\App\Models\_IH_User_QB;
    use LaravelIdea\Helper\App\Models\_IH_Video_C;
    use LaravelIdea\Helper\App\Models\_IH_Video_QB;
    use LaravelIdea\Helper\Illuminate\Notifications\_IH_DatabaseNotification_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Permission_QB;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_C;
    use LaravelIdea\Helper\Spatie\Permission\Models\_IH_Role_QB;
    use Spatie\Permission\Models\Permission;
    use Spatie\Permission\Models\Role;

    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property string|null $subject
     * @property string $message
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_ContactMessage_QB onWriteConnection()
     * @method _IH_ContactMessage_QB newQuery()
     * @method static _IH_ContactMessage_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_ContactMessage_QB query()
     * @method static _IH_ContactMessage_QB with(array|string $relations)
     * @method _IH_ContactMessage_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_ContactMessage_C|ContactMessage[] all($columns = ['*'])
     * @mixin _IH_ContactMessage_QB
     */
    class ContactMessage extends Model {}

    /**
     * @property int $id
     * @property string $domain
     * @property string $status
     * @property Carbon|null $requested_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_CrawlRequest_QB onWriteConnection()
     * @method _IH_CrawlRequest_QB newQuery()
     * @method static _IH_CrawlRequest_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_CrawlRequest_QB query()
     * @method static _IH_CrawlRequest_QB with(array|string $relations)
     * @method _IH_CrawlRequest_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_CrawlRequest_C|CrawlRequest[] all($columns = ['*'])
     * @mixin _IH_CrawlRequest_QB
     */
    class CrawlRequest extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string|null $robots_txt_status
     * @property string $crawl_priority
     * @property Carbon|null $last_crawled_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property string|null $homepage_url
     * @property string|null $site_name
     * @property string|null $default_language
     * @property string|null $favicon_url
     * @property string|null $robots_txt_url
     * @property Carbon|null $robots_fetched_at
     * @property int|null $robots_status_code
     * @property int|null $crawl_delay_seconds
     * @property int|null $last_http_status
     * @property string|null $last_error
     * @property bool $is_blocked
     * @property int $trust_score
     * @property int $pages_count
     * @method static _IH_Domain_QB onWriteConnection()
     * @method _IH_Domain_QB newQuery()
     * @method static _IH_Domain_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Domain_QB query()
     * @method static _IH_Domain_QB with(array|string $relations)
     * @method _IH_Domain_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Domain_C|Domain[] all($columns = ['*'])
     * @foreignLinks id,\App\Models\Page,domain_id|id,\App\Models\DomainIcon,domain_id|id,\App\Models\DomainSitemap,domain_id|id,\App\Models\DomainFeed,domain_id
     * @mixin _IH_Domain_QB
     */
    class Domain extends Model {}

    /**
     * @property int $id
     * @property int $domain_id
     * @property string $url
     * @property string|null $type
     * @property int|null $last_status_code
     * @property Carbon|null $last_fetched_at
     * @property Carbon|null $next_fetch_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Domain $domain
     * @method BelongsTo|_IH_Domain_QB domain()
     * @method static _IH_DomainFeed_QB onWriteConnection()
     * @method _IH_DomainFeed_QB newQuery()
     * @method static _IH_DomainFeed_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_DomainFeed_QB query()
     * @method static _IH_DomainFeed_QB with(array|string $relations)
     * @method _IH_DomainFeed_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DomainFeed_C|DomainFeed[] all($columns = ['*'])
     * @ownLinks domain_id,\App\Models\Domain,id
     * @mixin _IH_DomainFeed_QB
     */
    class DomainFeed extends Model {}

    /**
     * @property int $id
     * @property int $domain_id
     * @property string $url
     * @property string|null $rel
     * @property string|null $sizes
     * @property string|null $type
     * @property bool $is_primary
     * @property Carbon|null $discovered_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Domain $domain
     * @method BelongsTo|_IH_Domain_QB domain()
     * @method static _IH_DomainIcon_QB onWriteConnection()
     * @method _IH_DomainIcon_QB newQuery()
     * @method static _IH_DomainIcon_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_DomainIcon_QB query()
     * @method static _IH_DomainIcon_QB with(array|string $relations)
     * @method _IH_DomainIcon_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DomainIcon_C|DomainIcon[] all($columns = ['*'])
     * @ownLinks domain_id,\App\Models\Domain,id
     * @mixin _IH_DomainIcon_QB
     */
    class DomainIcon extends Model {}

    /**
     * @property int $id
     * @property int $domain_id
     * @property string $url
     * @property string $discovered_from
     * @property int|null $last_status_code
     * @property string|null $etag
     * @property string|null $last_modified
     * @property Carbon|null $last_fetched_at
     * @property Carbon|null $next_fetch_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Domain $domain
     * @method BelongsTo|_IH_Domain_QB domain()
     * @method static _IH_DomainSitemap_QB onWriteConnection()
     * @method _IH_DomainSitemap_QB newQuery()
     * @method static _IH_DomainSitemap_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_DomainSitemap_QB query()
     * @method static _IH_DomainSitemap_QB with(array|string $relations)
     * @method _IH_DomainSitemap_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_DomainSitemap_C|DomainSitemap[] all($columns = ['*'])
     * @ownLinks domain_id,\App\Models\Domain,id
     * @mixin _IH_DomainSitemap_QB
     */
    class DomainSitemap extends Model {}

    /**
     * @property int $id
     * @property int $page_id
     * @property string $src
     * @property string|null $alt
     * @property string|null $title
     * @property int|null $width
     * @property int|null $height
     * @property string|null $mime
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Page $page
     * @method BelongsTo|_IH_Page_QB page()
     * @method static _IH_Image_QB onWriteConnection()
     * @method _IH_Image_QB newQuery()
     * @method static _IH_Image_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Image_QB query()
     * @method static _IH_Image_QB with(array|string $relations)
     * @method _IH_Image_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Image_C|Image[] all($columns = ['*'])
     * @ownLinks page_id,\App\Models\Page,id
     * @mixin _IH_Image_QB
     */
    class Image extends Model {}

    /**
     * @property int $id
     * @property int $from_page_id
     * @property string $to_url
     * @property string|null $anchor_text
     * @property bool $is_internal
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Page $page
     * @method BelongsTo|_IH_Page_QB page()
     * @method static _IH_Link_QB onWriteConnection()
     * @method _IH_Link_QB newQuery()
     * @method static _IH_Link_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Link_QB query()
     * @method static _IH_Link_QB with(array|string $relations)
     * @method _IH_Link_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Link_C|Link[] all($columns = ['*'])
     * @ownLinks from_page_id,\App\Models\Page,id
     * @mixin _IH_Link_QB
     */
    class Link extends Model {}

    /**
     * @property int $id
     * @property string $url
     * @property string $domain
     * @property string|null $title
     * @property string|null $description
     * @property string|null $language
     * @property string|null $content_type
     * @property Carbon|null $crawled_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property int|null $domain_id
     * @property PageBody $body
     * @method HasOne|_IH_PageBody_QB body()
     * @property _IH_Image_C|Image[] $images
     * @property-read int $images_count
     * @method HasMany|_IH_Image_QB images()
     * @property _IH_Link_C|Link[] $links
     * @property-read int $links_count
     * @method HasMany|_IH_Link_QB links()
     * @property _IH_SearchLog_C|SearchLog[] $searchLogs
     * @property-read int $search_logs_count
     * @method HasMany|_IH_SearchLog_QB searchLogs()
     * @property _IH_Video_C|Video[] $videos
     * @property-read int $videos_count
     * @method HasMany|_IH_Video_QB videos()
     * @method static _IH_Page_QB onWriteConnection()
     * @method _IH_Page_QB newQuery()
     * @method static _IH_Page_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Page_QB query()
     * @method static _IH_Page_QB with(array|string $relations)
     * @method _IH_Page_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Page_C|Page[] all($columns = ['*'])
     * @ownLinks domain_id,\App\Models\Domain,id
     * @foreignLinks id,\App\Models\Image,page_id|id,\App\Models\Link,from_page_id|id,\App\Models\SearchLog,clicked_page_id|id,\App\Models\Video,page_id|id,\App\Models\PageRank,page_id|id,\App\Models\Snapshot,page_id|id,\App\Models\PageBody,page_id
     * @mixin _IH_Page_QB
     * @method static PageFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class Page extends Model {}

    /**
     * @property int $page_id
     * @property string|null $content
     * @property string|null $html
     * @property array|null $schema_json
     * @property string|null $keywords
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Page $page
     * @method BelongsTo|_IH_Page_QB page()
     * @method static _IH_PageBody_QB onWriteConnection()
     * @method _IH_PageBody_QB newQuery()
     * @method static _IH_PageBody_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PageBody_QB query()
     * @method static _IH_PageBody_QB with(array|string $relations)
     * @method _IH_PageBody_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PageBody_C|PageBody[] all($columns = ['*'])
     * @ownLinks page_id,\App\Models\Page,id
     * @mixin _IH_PageBody_QB
     */
    class PageBody extends Model {}

    /**
     * @property int $id
     * @property int $page_id
     * @property float $score
     * @property string $method
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Page $page
     * @method BelongsTo|_IH_Page_QB page()
     * @method static _IH_PageRank_QB onWriteConnection()
     * @method _IH_PageRank_QB newQuery()
     * @method static _IH_PageRank_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_PageRank_QB query()
     * @method static _IH_PageRank_QB with(array|string $relations)
     * @method _IH_PageRank_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_PageRank_C|PageRank[] all($columns = ['*'])
     * @ownLinks page_id,\App\Models\Page,id
     * @mixin _IH_PageRank_QB
     */
    class PageRank extends Model {}

    /**
     * @property int $id
     * @property string $query
     * @property string|null $ip_address
     * @property string|null $user_agent
     * @property int|null $clicked_page_id
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Page|null $page
     * @method BelongsTo|_IH_Page_QB page()
     * @method static _IH_SearchLog_QB onWriteConnection()
     * @method _IH_SearchLog_QB newQuery()
     * @method static _IH_SearchLog_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_SearchLog_QB query()
     * @method static _IH_SearchLog_QB with(array|string $relations)
     * @method _IH_SearchLog_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_SearchLog_C|SearchLog[] all($columns = ['*'])
     * @ownLinks clicked_page_id,\App\Models\Page,id
     * @mixin _IH_SearchLog_QB
     */
    class SearchLog extends Model {}

    /**
     * @property int $id
     * @property string|null $env
     * @property string $group
     * @property string $key
     * @property string $value
     * @property array|null $data
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @method static _IH_Setting_QB onWriteConnection()
     * @method _IH_Setting_QB newQuery()
     * @method static _IH_Setting_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Setting_QB query()
     * @method static _IH_Setting_QB with(array|string $relations)
     * @method _IH_Setting_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Setting_C|Setting[] all($columns = ['*'])
     * @mixin _IH_Setting_QB
     */
    class Setting extends Model {}

    /**
     * @property int $id
     * @property int $page_id
     * @property string $html
     * @property Carbon $snapshot_at
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Page $page
     * @method BelongsTo|_IH_Page_QB page()
     * @method static _IH_Snapshot_QB onWriteConnection()
     * @method _IH_Snapshot_QB newQuery()
     * @method static _IH_Snapshot_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Snapshot_QB query()
     * @method static _IH_Snapshot_QB with(array|string $relations)
     * @method _IH_Snapshot_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Snapshot_C|Snapshot[] all($columns = ['*'])
     * @ownLinks page_id,\App\Models\Page,id
     * @mixin _IH_Snapshot_QB
     */
    class Snapshot extends Model {}

    /**
     * @property int $id
     * @property string $name
     * @property string $email
     * @property Carbon|null $email_verified_at
     * @property mixed $password
     * @property string|null $remember_token
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property DatabaseNotificationCollection|DatabaseNotification[] $notifications
     * @property-read int $notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB notifications()
     * @property _IH_Permission_C|Permission[] $permissions
     * @property-read int $permissions_count
     * @method MorphToMany|_IH_Permission_QB permissions()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $readNotifications
     * @property-read int $read_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB readNotifications()
     * @property _IH_Role_C|Role[] $roles
     * @property-read int $roles_count
     * @method MorphToMany|_IH_Role_QB roles()
     * @property DatabaseNotificationCollection|DatabaseNotification[] $unreadNotifications
     * @property-read int $unread_notifications_count
     * @method MorphToMany|_IH_DatabaseNotification_QB unreadNotifications()
     * @method static _IH_User_QB onWriteConnection()
     * @method _IH_User_QB newQuery()
     * @method static _IH_User_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_User_QB query()
     * @method static _IH_User_QB with(array|string $relations)
     * @method _IH_User_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_User_C|User[] all($columns = ['*'])
     * @foreignLinks
     * @mixin _IH_User_QB
     * @method static UserFactory factory(callable|int|mixed[]|null $count = null, callable|mixed[] $state = [])
     */
    class User extends Model {}

    /**
     * @property int $id
     * @property int $page_id
     * @property string $src
     * @property string|null $title
     * @property int|null $duration
     * @property string|null $type
     * @property Carbon|null $created_at
     * @property Carbon|null $updated_at
     * @property Page $page
     * @method BelongsTo|_IH_Page_QB page()
     * @method static _IH_Video_QB onWriteConnection()
     * @method _IH_Video_QB newQuery()
     * @method static _IH_Video_QB on(null|string|\UnitEnum $connection = null)
     * @method static _IH_Video_QB query()
     * @method static _IH_Video_QB with(array|string $relations)
     * @method _IH_Video_QB newModelQuery()
     * @method false|int increment(string $column, float|int $amount = 1, array $extra = [])
     * @method false|int decrement(string $column, float|int $amount = 1, array $extra = [])
     * @method static _IH_Video_C|Video[] all($columns = ['*'])
     * @ownLinks page_id,\App\Models\Page,id
     * @mixin _IH_Video_QB
     */
    class Video extends Model {}
}
