<?php

namespace Tests\Feature;

use Tests\TestCase;
use App\Models\Page;
use Illuminate\Foundation\Testing\WithFaker;
use Illuminate\Foundation\Testing\RefreshDatabase;

class CrawlerApiTest extends TestCase
{
    use RefreshDatabase;

    public function test_it_can_store_a_page()
    {
        $response = $this->postJson('/api/v1/pages', [
            'url' => 'https://example.com/page1',
            'domain' => 'example.com',
            'title' => 'Test Page',
            'description' => 'This is a description',
            'content' => 'Page content here',
            'keywords' => 'test, example',
            'schema' => '{}'
        ]);

        $response->assertStatus(200)
            ->assertJsonStructure(['status', 'message', 'data' => ['id']]);
    }

    public function test_it_can_store_an_image()
    {
        $page = Page::factory()->create();

        $response = $this->postJson('/api/v1/images', [
            'page_id' => $page->id,
            'src' => 'https://example.com/image.jpg',
            'alt' => 'An image',
            'title' => 'Image title',
            'width' => 800,
            'height' => 600,
            'mime' => 'image/jpeg',
        ]);

        $response->assertStatus(200)
            ->assertJsonStructure(['status', 'message', 'data' => ['id']]);
    }

    public function test_it_can_store_a_video()
    {
        $page = Page::factory()->create();

        $response = $this->postJson('/api/v1/videos', [
            'page_id' => $page->id,
            'src' => 'https://youtube.com/embed/abc123',
            'title' => 'Video Title',
            'duration' => 120,
            'type' => 'youtube'
        ]);

        $response->assertStatus(200)
            ->assertJsonStructure(['status', 'message', 'data' => ['id']]);
    }

    public function test_it_can_store_a_link()
    {
        $page = Page::factory()->create();

        $response = $this->postJson('/api/v1/links', [
            'from_page_id' => $page->id,
            'to_url' => 'https://example.com/another-page',
            'anchor_text' => 'Click here',
            'is_internal' => true
        ]);

        $response->assertStatus(200)
            ->assertJsonStructure(['status', 'message', 'data' => ['id']]);
    }

    public function test_it_can_store_a_domain()
    {
        $response = $this->postJson('/api/v1/domains', [
            'name' => 'example.com',
            'robots_txt_status' => 'allowed',
            'crawl_priority' => 'normal',
            'last_crawled_at' => now()->toDateTimeString()
        ]);

        $response->assertStatus(200)
            ->assertJsonStructure(['status', 'message', 'data' => ['id']]);
    }

    public function test_it_can_store_a_search_log()
    {
        $response = $this->postJson('/api/v1/search-logs', [
            'query' => 'laravel testing',
            'ip_address' => '127.0.0.1',
            'user_agent' => 'PHPUnit',
            'clicked_page_id' => null
        ]);

        $response->assertStatus(200)
            ->assertJsonStructure(['status', 'message', 'data' => ['id']]);
    }
}
