<?php

use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\LogoutController;
use App\Http\Controllers\HomePageController;
use App\Services\AparatService;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\ContactUsController;


Route::get('/test', function () {
    $username = 'tvroyan';
    $profile = (new AparatService)->getProfile($username)->json();
    $profileVideo = (new AparatService)->getUserVideos($username, 20)->json();
    $profile['profile']['videobyuser'] = $profileVideo['videobyuser'];

    dd($profile['profile']['has_live'], $profile, $profileVideo , \App\Models\User::find(1)->aparat_profile);

})->name('home');


Route::get('/', [HomePageController::class, 'index'])->name('home');
Route::view('/live', 'pages.live')->name('live')->middleware('auth');


Route::view('/contact-us', 'pages.contact-us')->name('contact-us');
Route::post('/contact-us', [ContactUsController::class, 'store']);


Route::middleware(['guest'])->group(function () {
    Route::view('/login', 'pages.auth.login')->name('login');
    Route::post('login', [LoginController::class, 'login']);
    Route::view('/register', 'pages.auth.register')->name('register');
    Route::post('register', [RegisterController::class, 'register']);
});

Route::post('logout', LogoutController::class)->name('logout')->middleware('auth');


Route::prefix('user')->name('user.')->middleware(['auth'])->group(function () {
    Route::view('dashboard', 'pages.user.dashboard')->name('dashboard');
});


