<?php

use App\Http\Controllers\Api\V1\CrawlRequestController;
use App\Http\Controllers\Api\V1\DomainFeedController;
use App\Http\Controllers\Api\V1\DomainSiteMapController;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\V1\LinkController;
use App\Http\Controllers\Api\V1\ImageController;
use App\Http\Controllers\Api\V1\VideoController;
use App\Http\Controllers\Api\V1\DomainController;
use App\Http\Controllers\Api\V1\PageCrawlController;
use App\Http\Controllers\Api\V1\SearchLogController;

Route::prefix('v1')->name('api.v1.')->group(function () {


    Route::middleware('script-auth')->group(function () {
        Route::any('auth-up', function (Request $request) {
            return Response::api([$request->all(), $request->headers]);
        });
        Route::post('/pages/store', [PageCrawlController::class, 'store']);

        Route::post('/images', [ImageController::class, 'store']);
        Route::post('/videos', [VideoController::class, 'store']);
        Route::post('/links', [LinkController::class, 'store']);

        // Optional
        Route::post('/domains', [DomainController::class, 'store']);
        Route::post('/search-logs', [SearchLogController::class, 'store']);

        Route::prefix('domains')->name('domains.')->group(function () {
            Route::post('/sitemaps/store', [DomainSiteMapController::class, 'store']);
            Route::post('/feeds/store', [DomainFeedController::class, 'store']);
        });

        Route::prefix('crawl-requests')->name('crawl-requests.')->group(function () {
            Route::post('/index', [CrawlRequestController::class, 'index']);

            Route::post('update/{id}/status', [CrawlRequestController::class, 'updateStatus']);
        });
    });
});
