<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Hash;
use Illuminate\Http\Request;

Route::prefix('settings')->name('settings.')->group(function () {

    Route::get('generate-script-token', function (Request $request) {
        if ($request->has('regenerate-script-token')) {
            $secret = Str::random(40);

            Cache::forget('script-token');

            $value = Cache::rememberForever('script-token', function ()  use ($secret) {
                return Hash::make($secret);
            });

            return view('pages.admin.script-token', compact('value', 'secret'));
        }
        $secret = Cache::get('script-token');

        return view('pages.admin.script-token', compact('secret'));
    })->name('script-token');

});


