<?php


use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\UserControllers;
use App\Http\Controllers\Admin\CrawlRequestController;
use App\Http\Controllers\Admin\AdminDashboardController;
use App\Http\Controllers\Admin\CrawlRequestSyncController;


Route::view('contact-us-submissions', 'pages.admin.contact-us-submissions')->name('contact-us-submissions');

Route::get('/dashboard', [AdminDashboardController::class, 'index'])->name('dashboard');
Route::view('/settings', 'pages.admin.settings')->name('settings');


Route::post('crawl-request/update/{id}/status', [CrawlRequestController::class, 'updateStatus'])->name('crawl-request.update-status');
Route::post('/crawl-requests/sync-domains', [CrawlRequestSyncController::class, 'syncToDomains'])->name('crawl_requests.sync_domains');

// resources
Route::resource('users', UserControllers::class);
Route::resource('crawl-requests', CrawlRequestController::class);
Route::resource('domains', \App\Http\Controllers\Admin\DomainController::class);
