<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>TV Royan — Live</title>
    @vite(['resources/css/base.css', 'resources/js/base.js'])
    @include('pages.tvroyan.script')
</head>

<body class="min-h-screen bg-slate-950 text-slate-100"
      x-data="tvRoyan()"
      x-init="init(); chat.init()">


<!-- Header -->
<header class="border-b border-white/10 bg-slate-950/80 backdrop-blur sticky top-0 z-50">
    <div class="mx-auto max-w-6xl px-4 py-3 flex items-center justify-between gap-3">
        <a href="./index.html" class="flex items-center gap-3">
            <div class="h-9 w-9 rounded-xl bg-white/10 grid place-items-center border border-white/10">
                <span class="font-semibold">R</span>
            </div>
            <div class="leading-tight">
                <div class="font-semibold" x-text="brand.name"></div>
                <div class="text-xs text-slate-400">Live</div>
            </div>
        </a>

        <div class="flex items-center gap-2">
            <a href="./index.html" class="px-3 py-2 rounded-xl border border-white/10 bg-white/5 hover:bg-white/10 text-sm">Home</a>
            <button class="px-3 py-2 rounded-xl bg-white text-slate-950 hover:bg-slate-200 text-sm font-semibold"
                    @click="authModalOpen=true; authTab='login'">
                Login
            </button>
        </div>
    </div>
</header>

<!-- Main -->
<main class="mx-auto max-w-6xl px-4 py-6">
    <div class="grid lg:grid-cols-12 gap-5">
        <!-- Video -->
        <section class="lg:col-span-8 rounded-3xl border border-white/10 bg-white/5 overflow-hidden">
            <div class="p-4 border-b border-white/10 flex items-center justify-between">
                <div>
                    <div class="flex items-center gap-2">
              <span class="inline-flex items-center gap-2 px-3 py-1 rounded-full border border-white/10 bg-black/20 text-xs text-slate-300">
                <span class="h-2 w-2 rounded-full" :class="live.isLive ? 'bg-emerald-400' : 'bg-slate-500'"></span>
                <span x-text="live.isLive ? 'LIVE' : 'OFFLINE'"></span>
              </span>
                        <span class="text-sm text-slate-400" x-show="live.isLive">
                <span x-text="live.viewers"></span> watching
              </span>
                    </div>
                    <div class="mt-2 font-semibold" x-text="live.title"></div>
                    <div class="text-sm text-slate-400">Host: <span x-text="live.host"></span></div>
                </div>

                <div class="flex gap-2">
                    <a :href="links.aparat" class="px-3 py-2 rounded-xl border border-white/10 bg-white/5 hover:bg-white/10 text-sm">Aparat</a>
                    <a :href="links.youtube" class="px-3 py-2 rounded-xl border border-white/10 bg-white/5 hover:bg-white/10 text-sm">YouTube</a>
                </div>
            </div>

            <div class="aspect-video bg-black">
                <!-- Replace liveEmbed.src with a real working embed URL from Aparat/YouTube -->
                <iframe
                    class="w-full h-full"
                    :src="liveEmbed.src"
                    title="TV Royan Live"
                    frameborder="0"
                    allow="autoplay; encrypted-media; picture-in-picture"
                    allowfullscreen>
                </iframe>
            </div>

            <div class="p-4 text-sm text-slate-300">
                Tip: For Aparat, open a live video and use the platform “Embed” option to get the correct iframe URL.
            </div>
        </section>

        <!-- Chat -->
        <aside class="lg:col-span-4 rounded-3xl border border-white/10 bg-white/5 overflow-hidden flex flex-col">
            <div class="p-4 border-b border-white/10 flex items-center justify-between">
                <div class="font-semibold">Live Chat</div>
                <button class="px-3 py-2 rounded-xl border border-white/10 bg-white/5 hover:bg-white/10 text-xs"
                        @click="chat.clear()">
                    Clear
                </button>
            </div>

            <div id="chatScroll" class="flex-1 overflow-y-auto p-4 space-y-3">
                <template x-for="m in chat.messages" :key="m.id">
                    <div class="rounded-2xl border border-white/10 bg-black/20 p-3">
                        <div class="flex items-center justify-between gap-3">
                            <div class="text-sm font-semibold truncate" x-text="m.name"></div>
                            <div class="text-xs text-slate-500" x-text="new Date(m.at).toLocaleTimeString()"></div>
                        </div>
                        <div class="mt-2 text-sm text-slate-200 whitespace-pre-wrap break-words" x-text="m.text"></div>
                    </div>
                </template>

                <div x-show="chat.messages.length===0" class="text-sm text-slate-400">
                    No messages yet. Say hi 👋
                </div>
            </div>

            <div class="p-4 border-t border-white/10 space-y-2">
                <div class="flex gap-2">
                    <input class="w-36 px-3 py-2 rounded-xl bg-white/5 border border-white/10 focus:outline-none focus:ring-2 focus:ring-white/20 text-sm"
                           type="text"
                           x-model="chat.username"
                           placeholder="Name"
                           @change="localStorage.setItem('tvroyan_guest_name_v1', chat.username)"/>
                    <div class="flex-1"></div>
                </div>

                <div class="flex gap-2">
                    <input class="flex-1 px-3 py-3 rounded-xl bg-white/5 border border-white/10 focus:outline-none focus:ring-2 focus:ring-white/20 text-sm"
                           type="text"
                           x-model="chat.message"
                           placeholder="Type a message…"
                           @keydown.enter.prevent="chat.send()"/>
                    <button class="px-4 py-3 rounded-xl bg-white text-slate-950 hover:bg-slate-200 text-sm font-semibold"
                            @click="chat.send()">
                        Send
                    </button>
                </div>

                <p class="text-xs text-slate-500">
                    This chat is demo (browser-only). Connect it to your real socket server later.
                </p>
            </div>
        </aside>
    </div>
</main>

<!-- Auth modal reused from home (simple) -->
<div class="fixed inset-0 z-50" x-show="authModalOpen" x-transition>
    <div class="absolute inset-0 bg-black/60" @click="authModalOpen=false"></div>
    <div class="absolute inset-0 grid place-items-center p-4">
        <div class="w-full max-w-md rounded-3xl border border-white/10 bg-slate-950 shadow-2xl overflow-hidden">
            <div class="p-5 border-b border-white/10 flex items-center justify-between">
                <div class="font-semibold" x-text="authTab==='login' ? 'Login' : 'Register'"></div>
                <button class="p-2 rounded-xl hover:bg-white/10" @click="authModalOpen=false">✕</button>
            </div>
            <div class="p-5">
                <div class="flex gap-2 mb-4">
                    <button class="flex-1 px-3 py-2 rounded-xl border text-sm"
                            :class="authTab==='login' ? 'border-white/20 bg-white/10' : 'border-white/10 bg-white/5 hover:bg-white/10'"
                            @click="authTab='login'">Login
                    </button>
                    <button class="flex-1 px-3 py-2 rounded-xl border text-sm"
                            :class="authTab==='register' ? 'border-white/20 bg-white/10' : 'border-white/10 bg-white/5 hover:bg-white/10'"
                            @click="authTab='register'">Register
                    </button>
                </div>

                <form x-show="authTab==='login'" class="space-y-3">
                    <input class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10" type="email" placeholder="Email"/>
                    <input class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10" type="password" placeholder="Password"/>
                    <button type="button" class="w-full px-4 py-3 rounded-xl bg-white text-slate-950 hover:bg-slate-200 font-semibold">
                        Login
                    </button>
                </form>

                <form x-show="authTab==='register'" class="space-y-3">
                    <input class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10" type="text" placeholder="Name"/>
                    <input class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10" type="email" placeholder="Email"/>
                    <input class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10" type="password" placeholder="Password"/>
                    <button type="button" class="w-full px-4 py-3 rounded-xl bg-white text-slate-950 hover:bg-slate-200 font-semibold">
                        Create account
                    </button>
                </form>
            </div>
        </div>
    </div>
</div>

@include('pages.tvroyan.script')

</body>
</html>
