<!doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
<head>
    <meta charset="utf-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title>{{ __('TV Royan — Home') }}</title>

   @vite(['resources/css/app.css', 'resources/js/app.js'])
</head>

<body
    x-data="bodyInitializer"
    x-init="init()"
    :class="theme.mode === 'dark' ? 'bg-slate-950 text-slate-100' : 'bg-slate-900 text-slate-900'"
    class="min-h-screen transition-colors "
>

<!-- Header -->
<header
    class="sticky top-0 z-50 border-b backdrop-blur transition-colors"
    :class="theme.mode === 'dark'
      ? 'border-white/10 bg-slate-950/80'
      : 'border-slate-200 bg-white/80'"
>
    <div class="mx-auto max-w-6xl px-4 py-3 flex items-center justify-between gap-3">
        <a href="{{ url('/') }}" class="flex items-center gap-3">
            <div
                class="h-9 w-9 rounded-xl grid place-items-center border transition-colors"
                :class="theme.mode === 'dark'
            ? 'bg-white/10 border-white/10'
            : 'bg-slate-900/5 border-slate-200'"
            >
                <span class="font-semibold">{{ __('R') }}</span>
            </div>

            <div class="leading-tight">
                <div class="font-semibold" x-text="brand.name"></div>
                <div class="text-xs" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-500'" x-text="brand.domain"></div>
            </div>
        </a>

        <nav class="hidden md:flex items-center gap-6 text-sm">
            <a href="{{ url('/live') }}" class="hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-600'">
                {{ __('Live') }}
            </a>
            <a href="#schedule" class="hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-600'">
                {{ __('Schedule') }}
            </a>
            <a href="#team" class="hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-600'">
                {{ __('Team') }}
            </a>
            <a href="{{ url('/about') }}" class="hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-600'">
                {{ __('About') }}
            </a>
            <a href="{{ url('/contact') }}" class="hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-600'">
                {{ __('Contact') }}
            </a>
        </nav>

        <div class="flex items-center gap-2">
            <!-- Theme Toggle -->
            <button
                type="button"
                class="inline-flex items-center gap-2 px-3 py-2 rounded-xl border text-sm transition-colors"
                :class="theme.mode === 'dark'
            ? 'border-white/10 bg-white/5 hover:bg-white/10'
            : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'"
                @click="theme.toggle()"
                :aria-label="theme.mode === 'dark' ? '{{ __('Switch to light mode') }}' : '{{ __('Switch to dark mode') }}'"
            >
                <span x-show="theme.mode === 'dark'">☀️</span>
                <span x-show="theme.mode === 'light'">🌙</span>
                <span class="hidden sm:inline" x-text="theme.mode === 'dark' ? '{{ __('Light') }}' : '{{ __('Dark') }}'"></span>
            </button>

            <button
                class="hidden md:inline-flex px-3 py-2 rounded-xl border text-sm transition-colors"
                :class="theme.mode === 'dark'
            ? 'border-white/10 bg-white/5 hover:bg-white/10'
            : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'"
                @click="authModalOpen=true; authTab='login'"
            >
                {{ __('Login') }}
            </button>

            <button
                class="hidden md:inline-flex px-3 py-2 rounded-xl text-sm font-semibold transition-colors"
                :class="theme.mode === 'dark'
            ? 'bg-white text-slate-950 hover:bg-slate-200'
            : 'bg-slate-900 text-white hover:bg-slate-800'"
                @click="authModalOpen=true; authTab='register'"
            >
                {{ __('Register') }}
            </button>

            <button
                class="md:hidden px-3 py-2 rounded-xl border transition-colors"
                :class="theme.mode === 'dark'
            ? 'border-white/10 bg-white/5 hover:bg-white/10'
            : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'"
                @click="mobileMenuOpen=!mobileMenuOpen"
                aria-label="{{ __('Open menu') }}"
            >
                <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none">
                    <path d="M4 6h16M4 12h16M4 18h16" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                </svg>
            </button>
        </div>
    </div>

    <!-- Mobile menu -->
    <div class="md:hidden border-t transition-colors" :class="theme.mode === 'dark' ? 'border-white/10' : 'border-slate-200'" x-show="mobileMenuOpen" x-transition>
        <div class="mx-auto max-w-6xl px-4 py-3 flex flex-col gap-2 text-sm">
            <a href="{{ url('/live') }}" class="py-2 hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">{{ __('Live') }}</a>
            <a href="#schedule" class="py-2 hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">{{ __('Schedule') }}</a>
            <a href="#team" class="py-2 hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">{{ __('Team') }}</a>
            <a href="{{ url('/about') }}" class="py-2 hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">{{ __('About') }}</a>
            <a href="{{ url('/contact') }}" class="py-2 hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">{{ __('Contact') }}</a>

            <div class="pt-2 flex gap-2">
                <button
                    class="flex-1 px-3 py-2 rounded-xl border transition-colors"
                    :class="theme.mode === 'dark'
              ? 'border-white/10 bg-white/5 hover:bg-white/10'
              : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'"
                    @click="authModalOpen=true; authTab='login'"
                >
                    {{ __('Login') }}
                </button>
                <button
                    class="flex-1 px-3 py-2 rounded-xl font-semibold transition-colors"
                    :class="theme.mode === 'dark'
              ? 'bg-white text-slate-950 hover:bg-slate-200'
              : 'bg-slate-900 text-white hover:bg-slate-800'"
                    @click="authModalOpen=true; authTab='register'"
                >
                    {{ __('Register') }}
                </button>
            </div>
        </div>
    </div>
</header>

<!-- Hero -->
<section class="mx-auto max-w-6xl px-4 pt-10 pb-6">
    <div class="grid lg:grid-cols-2 gap-6 items-stretch">
        <div
            class="rounded-3xl border p-7 transition-colors"
            :class="theme.mode === 'dark'
          ? 'border-white/10 bg-gradient-to-b from-white/10 to-white/5'
          : 'border-slate-200 bg-white'"
        >
            <div
                class="inline-flex items-center gap-2 px-3 py-1 rounded-full border text-xs transition-colors"
                :class="theme.mode === 'dark'
            ? 'border-white/10 bg-black/20 text-slate-300'
            : 'border-slate-200 bg-slate-900/5 text-slate-700'"
            >
                <span class="h-2 w-2 rounded-full" :class="live.isLive ? 'bg-emerald-400' : (theme.mode==='dark' ? 'bg-slate-500' : 'bg-slate-400')"></span>
                <span x-text="live.isLive ? '{{ __('LIVE NOW') }}' : '{{ __('Offline (daily live hours)') }}'"></span>
            </div>

            <h1 class="mt-4 text-3xl md:text-4xl font-semibold tracking-tight">
                {{ __('Royan TV — live sessions for coding & 3D.') }}
            </h1>

            <p class="mt-3 leading-relaxed" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">
                {{ __('We go live a few hours per day with practical learning, real projects, and community Q&A.') }}
            </p>

            <div class="mt-6 flex flex-wrap gap-3">
                <a
                    href="{{ url('/live') }}"
                    class="px-4 py-2 rounded-xl font-semibold transition-colors"
                    :class="theme.mode === 'dark'
              ? 'bg-white text-slate-950 hover:bg-slate-200'
              : 'bg-slate-900 text-white hover:bg-slate-800'"
                >
                    {{ __('Watch Live') }}
                </a>

                <a
                    href="#schedule"
                    class="px-4 py-2 rounded-xl border transition-colors"
                    :class="theme.mode === 'dark'
              ? 'border-white/10 bg-white/5 hover:bg-white/10 text-slate-100'
              : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10 text-slate-900'"
                >
                    {{ __('Weekly Schedule') }}
                </a>
            </div>

            <div class="mt-6 grid sm:grid-cols-3 gap-3 text-sm">
                <div class="rounded-2xl border p-4 transition-colors" :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20' : 'border-slate-200 bg-slate-900/5'">
                    <div :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">{{ __('Status') }}</div>
                    <div class="mt-1 font-semibold" x-text="live.isLive ? '{{ __('On Air') }}' : '{{ __('Offline') }}'"></div>
                </div>

                <div class="rounded-2xl border p-4 transition-colors" :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20' : 'border-slate-200 bg-slate-900/5'">
                    <div :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">{{ __('Current Show') }}</div>
                    <div class="mt-1 font-semibold truncate" x-text="live.title"></div>
                </div>

                <div class="rounded-2xl border p-4 transition-colors" :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20' : 'border-slate-200 bg-slate-900/5'">
                    <div :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">{{ __('Viewers') }}</div>
                    <div class="mt-1 font-semibold" x-text="live.isLive ? live.viewers : '—'"></div>
                </div>
            </div>
        </div>

        <!-- Live card preview -->
        <div class="rounded-3xl border overflow-hidden flex flex-col transition-colors"
             :class="theme.mode === 'dark' ? 'border-white/10 bg-white/5' : 'border-slate-200 bg-white'">
            <div class="p-4 border-b flex items-center justify-between transition-colors"
                 :class="theme.mode === 'dark' ? 'border-white/10' : 'border-slate-200'">
                <div>
                    <div class="text-sm font-semibold">{{ __('Live Preview') }}</div>
                    <div class="text-xs" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">
                        {{ __('Open the full live page for video + chat.') }}
                    </div>
                </div>
                <a href="{{ url('/live') }}"
                   class="px-3 py-2 rounded-xl border text-sm transition-colors"
                   :class="theme.mode === 'dark' ? 'border-white/10 bg-white/5 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'">
                    {{ __('Open') }}
                </a>
            </div>

            <div class="flex-1 grid place-items-center p-6">
                <div class="w-full max-w-md rounded-2xl border p-6 text-center transition-colors"
                     :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20' : 'border-slate-200 bg-slate-900/5'">
                    <div class="mx-auto h-12 w-12 rounded-2xl border grid place-items-center transition-colors"
                         :class="theme.mode === 'dark' ? 'bg-white/10 border-white/10' : 'bg-white border-slate-200'">
                        <svg class="h-6 w-6" viewBox="0 0 24 24" fill="none">
                            <path d="M10 8l6 4-6 4V8z" fill="currentColor" opacity="0.9"/>
                        </svg>
                    </div>

                    <div class="mt-4 font-semibold" x-text="live.isLive ? '{{ __('We are live!') }}' : '{{ __('Next live session soon') }}'"></div>
                    <div class="mt-1 text-sm" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">
                        {{ __('Check the schedule below or open the live page.') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Social + Channels -->
<section class="mx-auto max-w-6xl px-4 py-6">
    <div class="grid lg:grid-cols-2 gap-6">
        <div class="rounded-3xl border p-6 transition-colors" :class="theme.mode === 'dark' ? 'border-white/10 bg-white/5' : 'border-slate-200 bg-white'">
            <h2 class="text-lg font-semibold">{{ __('Our Social Accounts') }}</h2>
            <p class="mt-1 text-sm" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">
                {{ __('Follow updates, highlights, and schedule changes.') }}
            </p>

            <div class="mt-5 grid sm:grid-cols-2 gap-3">
                <a :href="links.instagram" class="rounded-2xl border p-4 hover:opacity-95 transition-colors"
                   :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'">
                    <div class="text-sm font-semibold">{{ __('Instagram') }}</div>
                    <div class="text-xs break-all" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'" x-text="links.instagram"></div>
                </a>

                <a :href="links.telegram" class="rounded-2xl border p-4 hover:opacity-95 transition-colors"
                   :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'">
                    <div class="text-sm font-semibold">{{ __('Telegram') }}</div>
                    <div class="text-xs break-all" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'" x-text="links.telegram"></div>
                </a>

                <a :href="links.discord" class="rounded-2xl border p-4 hover:opacity-95 transition-colors"
                   :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'">
                    <div class="text-sm font-semibold">{{ __('Discord') }}</div>
                    <div class="text-xs break-all" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'" x-text="links.discord"></div>
                </a>

                <button
                    type="button"
                    class="rounded-2xl border p-4 hover:opacity-95 transition-colors text-start"
                    :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'"
                    @click="navigator.clipboard?.writeText(window.location.origin + '/live')"
                >
                    <div class="text-sm font-semibold">{{ __('Share Live Link') }}</div>
                    <div class="text-xs" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">
                        {{ __('Copy TV Royan live page link') }}
                    </div>
                </button>
            </div>
        </div>

        <div class="rounded-3xl border p-6 transition-colors" :class="theme.mode === 'dark' ? 'border-white/10 bg-white/5' : 'border-slate-200 bg-white'">
            <h2 class="text-lg font-semibold">{{ __('Our Channels') }}</h2>
            <p class="mt-1 text-sm" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">
                {{ __('Watch on your favorite platform.') }}
            </p>

            <div class="mt-5 grid sm:grid-cols-2 gap-3">
                <a :href="links.aparat" class="rounded-2xl border p-4 hover:opacity-95 transition-colors"
                   :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'">
                    <div class="text-sm font-semibold">{{ __('Aparat') }}</div>
                    <div class="text-xs" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">{{ __('Main channel') }}</div>
                </a>

                <a :href="links.youtube" class="rounded-2xl border p-4 hover:opacity-95 transition-colors"
                   :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'">
                    <div class="text-sm font-semibold">{{ __('YouTube') }}</div>
                    <div class="text-xs" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">{{ __('Clips + archives') }}</div>
                </a>

                <a href="{{ url('/live') }}"
                   class="sm:col-span-2 rounded-2xl p-4 hover:opacity-95 transition-colors"
                   :class="theme.mode === 'dark' ? 'bg-white text-slate-950 hover:bg-slate-200' : 'bg-slate-900 text-white hover:bg-slate-800'">
                    <div class="text-sm font-semibold">{{ __('TVRoyan Live Page') }}</div>
                    <div class="text-xs opacity-80">{{ __('Video + chat in one place') }}</div>
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Weekly Schedule -->
<section id="schedule" class="mx-auto max-w-6xl px-4 py-6">
    <div class="rounded-3xl border p-6 transition-colors" :class="theme.mode === 'dark' ? 'border-white/10 bg-white/5' : 'border-slate-200 bg-white'">
        <div class="flex flex-col sm:flex-row sm:items-end sm:justify-between gap-3">
            <div>
                <h2 class="text-lg font-semibold">{{ __('Weekly Schedule') }}</h2>
                <p class="mt-1 text-sm" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">
                    {{ __('Program times and hosts (adjust anytime).') }}
                </p>
            </div>

            <div class="text-xs" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'" x-show="live.lastCheckedAt">
                {{ __('Live status updated:') }}
                <span x-text="live.lastCheckedAt ? new Date(live.lastCheckedAt).toLocaleString() : ''"></span>
            </div>
        </div>

        <div class="mt-5 flex flex-wrap gap-2">
            <template x-for="(day, idx) in schedule.days" :key="day.name">
                <button
                    type="button"
                    class="px-3 py-2 rounded-xl border text-sm transition-colors"
                    :class="schedule.selectedDayIndex===idx
              ? (theme.mode === 'dark' ? 'border-white/20 bg-white/10' : 'border-slate-300 bg-slate-900/5')
              : (theme.mode === 'dark' ? 'border-white/10 bg-white/5 hover:bg-white/10 text-slate-200' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10 text-slate-800')"
                    @click="schedule.selectedDayIndex = idx"
                    x-text="day.name"
                ></button>
            </template>
        </div>

        <div class="mt-5 overflow-hidden rounded-2xl border transition-colors" :class="theme.mode === 'dark' ? 'border-white/10' : 'border-slate-200'">
            <table class="w-full text-sm">
                <thead class="transition-colors" :class="theme.mode === 'dark' ? 'bg-black/20 text-slate-300' : 'bg-slate-900/5 text-slate-700'">
                <tr>
                    <th class="text-start px-4 py-3 w-28">{{ __('Time') }}</th>
                    <th class="text-start px-4 py-3">{{ __('Program') }}</th>
                    <th class="text-start px-4 py-3 w-48">{{ __('Host') }}</th>
                </tr>
                </thead>

                <tbody class="divide-y transition-colors" :class="theme.mode === 'dark' ? 'divide-white/10' : 'divide-slate-200'">
                <template x-for="item in schedule.days[schedule.selectedDayIndex].items" :key="item.time + item.title">
                    <tr class="hover:opacity-95 transition-colors" :class="theme.mode === 'dark' ? 'hover:bg-white/5' : 'hover:bg-slate-900/5'">
                        <td class="px-4 py-3" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'" x-text="item.time"></td>
                        <td class="px-4 py-3 font-medium" x-text="item.title"></td>
                        <td class="px-4 py-3" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'" x-text="item.host"></td>
                    </tr>
                </template>

                <tr x-show="schedule.days[schedule.selectedDayIndex].items.length===0">
                    <td colspan="3" class="px-4 py-6 text-center" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">
                        {{ __('No programs scheduled for this day yet.') }}
                    </td>
                </tr>
                </tbody>
            </table>
        </div>
    </div>
</section>

<!-- Team -->
<section id="team" class="mx-auto max-w-6xl px-4 py-6">
    <div class="rounded-3xl border p-6 transition-colors" :class="theme.mode === 'dark' ? 'border-white/10 bg-white/5' : 'border-slate-200 bg-white'">
        <h2 class="text-lg font-semibold">{{ __('Team') }}</h2>
        <p class="mt-1 text-sm" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">
            {{ __('Meet the people behind Royan.') }}
        </p>

        <div class="mt-5 grid sm:grid-cols-2 lg:grid-cols-3 gap-4">
            <template x-for="member in team" :key="member.name">
                <div class="rounded-3xl border p-5 transition-colors"
                     :class="theme.mode === 'dark' ? 'border-white/10 bg-black/20' : 'border-slate-200 bg-slate-900/5'">
                    <div class="flex items-center gap-3">
                        <div class="h-11 w-11 rounded-2xl border grid place-items-center transition-colors"
                             :class="theme.mode === 'dark' ? 'bg-white/10 border-white/10' : 'bg-white border-slate-200'">
                            <span class="font-semibold" x-text="member.name.slice(0,1)"></span>
                        </div>
                        <div>
                            <div class="font-semibold" x-text="member.name"></div>
                            <div class="text-xs" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'" x-text="member.role"></div>
                        </div>
                    </div>
                    <p class="mt-4 text-sm leading-relaxed" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'" x-text="member.bio"></p>
                </div>
            </template>
        </div>
    </div>
</section>

<!-- About + Contact (summary) -->
<section class="mx-auto max-w-6xl px-4 py-6">
    <div class="grid lg:grid-cols-2 gap-6">
        <div class="rounded-3xl border p-6 transition-colors" :class="theme.mode === 'dark' ? 'border-white/10 bg-white/5' : 'border-slate-200 bg-white'">
            <h2 class="text-lg font-semibold">{{ __('About TV Royan') }}</h2>
            <p class="mt-2 text-sm leading-relaxed" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">
                {{ __('TV Royan started as an Aparat live channel. We go live a few hours per day and focus on practical learning: coding, building real projects, and 3D modeling.') }}
            </p>
            <a href="{{ url('/about') }}"
               class="mt-4 inline-flex px-3 py-2 rounded-xl border text-sm transition-colors"
               :class="theme.mode === 'dark' ? 'border-white/10 bg-white/5 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10'">
                {{ __('Read more') }}
            </a>
        </div>

        <div class="rounded-3xl border p-6 transition-colors" :class="theme.mode === 'dark' ? 'border-white/10 bg-white/5' : 'border-slate-200 bg-white'">
            <h2 class="text-lg font-semibold">{{ __('Contact Us') }}</h2>
            <p class="mt-2 text-sm leading-relaxed" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">
                {{ __('Want to collaborate, sponsor a session, or join the team?') }}
            </p>
            <a href="{{ url('/contact') }}"
               class="mt-4 inline-flex px-3 py-2 rounded-xl font-semibold transition-colors"
               :class="theme.mode === 'dark' ? 'bg-white text-slate-950 hover:bg-slate-200' : 'bg-slate-900 text-white hover:bg-slate-800'">
                {{ __('Contact') }}
            </a>
        </div>
    </div>
</section>

<!-- Footer -->
<footer class="border-t transition-colors" :class="theme.mode === 'dark' ? 'border-white/10' : 'border-slate-200'">
    <div class="mx-auto max-w-6xl px-4 py-8 flex flex-col md:flex-row gap-3 items-start md:items-center justify-between">
        <div class="text-sm" :class="theme.mode === 'dark' ? 'text-slate-400' : 'text-slate-600'">
            {{ __('©') }} <span x-text="new Date().getFullYear()"></span> <span x-text="brand.name"></span>. {{ __('All rights reserved.') }}
        </div>
        <div class="flex flex-wrap gap-4 text-sm">
            <a href="{{ url('/about') }}" class="hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">{{ __('About') }}</a>
            <a href="{{ url('/contact') }}" class="hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">{{ __('Contact') }}</a>
            <a href="{{ url('/live') }}" class="hover:opacity-90" :class="theme.mode === 'dark' ? 'text-slate-300' : 'text-slate-700'">{{ __('Live') }}</a>
        </div>
    </div>
</footer>

<!-- Login/Register Modal (texts updated to __()) -->
<div class="fixed inset-0 z-50" x-show="authModalOpen" x-transition>
    <div class="absolute inset-0 bg-black/60" @click="authModalOpen=false"></div>

    <div class="absolute inset-0 grid place-items-center p-4">
        <div class="w-full max-w-md rounded-3xl border shadow-2xl overflow-hidden transition-colors"
             :class="theme.mode === 'dark' ? 'border-white/10 bg-slate-950' : 'border-slate-200 bg-white'">

            <div class="p-5 border-b flex items-center justify-between transition-colors"
                 :class="theme.mode === 'dark' ? 'border-white/10' : 'border-slate-200'">
                <div class="font-semibold" x-text="authTab==='login' ? '{{ __('Login') }}' : '{{ __('Register') }}'"></div>
                <button class="p-2 rounded-xl hover:opacity-90" @click="authModalOpen=false" aria-label="{{ __('Close') }}">✕</button>
            </div>

            <div class="p-5">
                <div class="flex gap-2 mb-4">
                    <button class="flex-1 px-3 py-2 rounded-xl border text-sm transition-colors"
                            :class="authTab==='login'
                      ? (theme.mode==='dark' ? 'border-white/20 bg-white/10' : 'border-slate-300 bg-slate-900/5')
                      : (theme.mode==='dark' ? 'border-white/10 bg-white/5 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10')"
                            @click="authTab='login'">
                        {{ __('Login') }}
                    </button>
                    <button class="flex-1 px-3 py-2 rounded-xl border text-sm transition-colors"
                            :class="authTab==='register'
                      ? (theme.mode==='dark' ? 'border-white/20 bg-white/10' : 'border-slate-300 bg-slate-900/5')
                      : (theme.mode==='dark' ? 'border-white/10 bg-white/5 hover:bg-white/10' : 'border-slate-200 bg-slate-900/5 hover:bg-slate-900/10')"
                            @click="authTab='register'">
                        {{ __('Register') }}
                    </button>
                </div>

                <form x-show="authTab==='login'" class="space-y-3">
                    <input class="w-full px-4 py-3 rounded-xl border focus:outline-none focus:ring-2 transition-colors"
                           :class="theme.mode==='dark' ? 'bg-white/5 border-white/10 focus:ring-white/20' : 'bg-white border-slate-200 focus:ring-slate-300'"
                           type="email" placeholder="{{ __('Email') }}" />
                    <input class="w-full px-4 py-3 rounded-xl border focus:outline-none focus:ring-2 transition-colors"
                           :class="theme.mode==='dark' ? 'bg-white/5 border-white/10 focus:ring-white/20' : 'bg-white border-slate-200 focus:ring-slate-300'"
                           type="password" placeholder="{{ __('Password') }}" />

                    <button type="button"
                            class="w-full px-4 py-3 rounded-xl font-semibold transition-colors"
                            :class="theme.mode==='dark' ? 'bg-white text-slate-950 hover:bg-slate-200' : 'bg-slate-900 text-white hover:bg-slate-800'">
                        {{ __('Login') }}
                    </button>

                    <p class="text-xs" :class="theme.mode==='dark' ? 'text-slate-400' : 'text-slate-600'">
                        {{ __('Hook this form to your backend later (Laravel / Node / etc).') }}
                    </p>
                </form>

                <form x-show="authTab==='register'" class="space-y-3">
                    <input class="w-full px-4 py-3 rounded-xl border focus:outline-none focus:ring-2 transition-colors"
                           :class="theme.mode==='dark' ? 'bg-white/5 border-white/10 focus:ring-white/20' : 'bg-white border-slate-200 focus:ring-slate-300'"
                           type="text" placeholder="{{ __('Name') }}" />
                    <input class="w-full px-4 py-3 rounded-xl border focus:outline-none focus:ring-2 transition-colors"
                           :class="theme.mode==='dark' ? 'bg-white/5 border-white/10 focus:ring-white/20' : 'bg-white border-slate-200 focus:ring-slate-300'"
                           type="email" placeholder="{{ __('Email') }}" />
                    <input class="w-full px-4 py-3 rounded-xl border focus:outline-none focus:ring-2 transition-colors"
                           :class="theme.mode==='dark' ? 'bg-white/5 border-white/10 focus:ring-white/20' : 'bg-white border-slate-200 focus:ring-slate-300'"
                           type="password" placeholder="{{ __('Password') }}" />

                    <button type="button"
                            class="w-full px-4 py-3 rounded-xl font-semibold transition-colors"
                            :class="theme.mode==='dark' ? 'bg-white text-slate-950 hover:bg-slate-200' : 'bg-slate-900 text-white hover:bg-slate-800'">
                        {{ __('Create account') }}
                    </button>

                    <p class="text-xs" :class="theme.mode==='dark' ? 'text-slate-400' : 'text-slate-600'">
                        {{ __('Add email verification & password rules in your backend.') }}
                    </p>
                </form>
            </div>
        </div>
    </div>
</div>

</body>
</html>
