<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>TV Royan — Contact</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="./assets/app.js"></script>
</head>

<body class="min-h-screen bg-slate-950 text-slate-100" x-data="tvRoyan()" x-init="init()">
<header class="border-b border-white/10 bg-slate-950/80 backdrop-blur sticky top-0 z-50">
    <div class="mx-auto max-w-6xl px-4 py-3 flex items-center justify-between">
        <a href="./index.html" class="font-semibold">TV Royan</a>
        <nav class="flex gap-4 text-sm">
            <a href="./live.html" class="text-slate-300 hover:text-white">Live</a>
            <a href="./about.html" class="text-slate-300 hover:text-white">About</a>
        </nav>
    </div>
</header>

<main class="mx-auto max-w-6xl px-4 py-10">
    <div class="grid lg:grid-cols-2 gap-6">
        <div class="rounded-3xl border border-white/10 bg-white/5 p-7">
            <h1 class="text-3xl font-semibold">Contact Us</h1>
            <p class="mt-3 text-slate-300">
                Send a message for collaboration, sponsorship, or general questions.
            </p>

            <form class="mt-6 space-y-3">
                <input class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:outline-none focus:ring-2 focus:ring-white/20"
                       type="text" placeholder="Name"/>
                <input class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:outline-none focus:ring-2 focus:ring-white/20"
                       type="email" placeholder="Email"/>
                <textarea class="w-full px-4 py-3 rounded-xl bg-white/5 border border-white/10 focus:outline-none focus:ring-2 focus:ring-white/20"
                          rows="6" placeholder="Message"></textarea>

                <button type="button" class="w-full px-4 py-3 rounded-xl bg-white text-slate-950 hover:bg-slate-200 font-semibold">
                    Send message
                </button>

                <p class="text-xs text-slate-500">
                    Hook this form to your backend endpoint later (Laravel route, API, etc).
                </p>
            </form>
        </div>

        <div class="rounded-3xl border border-white/10 bg-white/5 p-7">
            <h2 class="text-lg font-semibold">Quick Links</h2>
            <div class="mt-4 space-y-3 text-sm">
                <a :href="links.aparat" class="block rounded-2xl border border-white/10 bg-black/20 p-4 hover:bg-white/10">Aparat</a>
                <a :href="links.youtube" class="block rounded-2xl border border-white/10 bg-black/20 p-4 hover:bg-white/10">YouTube</a>
                <a :href="links.instagram" class="block rounded-2xl border border-white/10 bg-black/20 p-4 hover:bg-white/10">Instagram</a>
                <a :href="links.telegram" class="block rounded-2xl border border-white/10 bg-black/20 p-4 hover:bg-white/10">Telegram</a>
            </div>

            <div class="mt-6 rounded-2xl border border-white/10 bg-black/20 p-5">
                <div class="font-semibold">Email</div>
                <p class="mt-2 text-sm text-slate-300">hello@tvroyan.com (placeholder)</p>
            </div>
        </div>
    </div>
</main>

<footer class="border-t border-white/10">
    <div class="mx-auto max-w-6xl px-4 py-8 text-sm text-slate-400">
        © <span x-text="new Date().getFullYear()"></span> TV Royan
    </div>
</footer>
</body>
</html>
