<!doctype html>
<html lang="en">
<head>
    <meta charset="utf-8"/>
    <meta name="viewport" content="width=device-width, initial-scale=1"/>
    <title>TV Royan — About</title>

    <script src="https://cdn.tailwindcss.com"></script>
    <script defer src="https://unpkg.com/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <script src="./assets/app.js"></script>
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @include('pages.tvroyan.script')
</head>

<body class="min-h-screen bg-slate-950 text-slate-100" x-data="tvRoyan()" x-init="init()">
<header class="border-b border-white/10 bg-slate-950/80 backdrop-blur sticky top-0 z-50">
    <div class="mx-auto max-w-6xl px-4 py-3 flex items-center justify-between">
        <a href="./index.html" class="font-semibold">TV Royan</a>
        <nav class="flex gap-4 text-sm">
            <a href="./live.html" class="text-slate-300 hover:text-white">Live</a>
            <a href="./contact.html" class="text-slate-300 hover:text-white">Contact</a>
        </nav>
    </div>
</header>

<main class="mx-auto max-w-6xl px-4 py-10">
    <div class="rounded-3xl border border-white/10 bg-white/5 p-7">
        <h1 class="text-3xl font-semibold">About TV Royan</h1>
        <p class="mt-4 text-slate-300 leading-relaxed">
            TV Royan is a small team-based channel that goes live a few hours per day.
            We focus on real-world learning: programming, building products, and 3D modeling.
        </p>

        <div class="mt-6 grid md:grid-cols-3 gap-4">
            <div class="rounded-2xl border border-white/10 bg-black/20 p-5">
                <div class="font-semibold">Mission</div>
                <p class="mt-2 text-sm text-slate-300">Help people learn by watching real work and real projects.</p>
            </div>
            <div class="rounded-2xl border border-white/10 bg-black/20 p-5">
                <div class="font-semibold">Content</div>
                <p class="mt-2 text-sm text-slate-300">Live coding, project building, 3D sessions, Q&A.</p>
            </div>
            <div class="rounded-2xl border border-white/10 bg-black/20 p-5">
                <div class="font-semibold">Community</div>
                <p class="mt-2 text-sm text-slate-300">Respectful chat, helpful feedback, and collaboration.</p>
            </div>
        </div>
    </div>
</main>

<footer class="border-t border-white/10">
    <div class="mx-auto max-w-6xl px-4 py-8 text-sm text-slate-400">
        © <span x-text="new Date().getFullYear()"></span> TV Royan
    </div>
</footer>
</body>
</html>
