<x-layouts.app title="Tables">

    <div class="mx-auto max-w-6xl space-y-10 p-6">

        {{-- Basic table --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Basic table</h2>

            <div class="table-wrap">
                <div class="table-scroll">
                    <table class="table">
                        <thead>
                            <tr>
                                <th class="text-start">Order</th>
                                <th class="text-start">Customer</th>
                                <th class="text-start">Status</th>
                                <th class="text-start">Created</th>
                                <th class="text-end">Amount</th>
                                <th class="text-end">Actions</th>
                            </tr>
                        </thead>

                        <tbody>
                            <tr>
                                <td class="td-strong">#3842</td>
                                <td class="td-muted">John Doe</td>
                                <td><span class="badge badge-soft-success badge-dot">Paid</span></td>
                                <td class="td-muted">2 hours ago</td>
                                <td class="text-end td-strong">€49</td>
                                <td class="text-end td-actions">
                                    <div class="inline-flex items-center gap-2">
                                        <button class="btn btn-soft-primary btn-sm">View</button>
                                        <button class="btn btn-secondary btn-sm">Invoice</button>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="td-strong">#3843</td>
                                <td class="td-muted">Jane Smith</td>
                                <td><span class="badge badge-soft-warning badge-dot">Awaiting</span></td>
                                <td class="td-muted">Yesterday</td>
                                <td class="text-end td-strong">€99</td>
                                <td class="text-end td-actions">
                                    <div class="inline-flex items-center gap-2">
                                        <button class="btn btn-soft-primary btn-sm">View</button>
                                        <button class="btn btn-outline-danger btn-sm">Cancel</button>
                                    </div>
                                </td>
                            </tr>

                            <tr>
                                <td class="td-strong">#3844</td>
                                <td class="td-muted">Ali</td>
                                <td><span class="badge badge-soft-danger badge-dot">Failed</span></td>
                                <td class="td-muted">Last week</td>
                                <td class="text-end td-strong">€49</td>
                                <td class="text-end td-actions">
                                    <div class="inline-flex items-center gap-2">
                                        <button class="btn btn-soft-primary btn-sm">View</button>
                                        <button class="btn btn-danger btn-sm">Retry</button>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>

                <div class="table-footer">
                    <p class="table-footer-meta">Showing 1 to 3 of 24 results</p>
                    <div class="table-footer-actions">
                        <button class="btn btn-secondary btn-sm">Prev</button>
                        <button class="btn btn-secondary btn-sm">Next</button>
                    </div>
                </div>
            </div>
        </section>

        {{-- Hover & striped --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Hover & striped</h2>

            <div class="table-wrap">
                <div class="table-scroll">
                    <table class="table table-hover table-striped">
                        <thead>
                            <tr>
                                <th class="text-start">Product</th>
                                <th class="text-start">Plan</th>
                                <th class="text-start">Status</th>
                                <th class="text-end">Price</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="td-strong">Telegram Order Bot</td>
                                <td class="td-muted">Starter</td>
                                <td><span class="badge badge-soft-success">Active</span></td>
                                <td class="text-end td-strong">€49</td>
                            </tr>
                            <tr>
                                <td class="td-strong">Telegram Order Bot</td>
                                <td class="td-muted">Pro</td>
                                <td><span class="badge badge-soft-success">Active</span></td>
                                <td class="text-end td-strong">€99</td>
                            </tr>
                            <tr>
                                <td class="td-strong">Telegram Order Bot</td>
                                <td class="td-muted">Business</td>
                                <td><span class="badge badge-soft-warning">Limited</span></td>
                                <td class="text-end td-strong">€199</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>

        {{-- Compact table --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Compact table</h2>

            <div class="table-wrap">
                <div class="table-scroll">
                    <table class="table table-compact table-hover">
                        <thead>
                            <tr>
                                <th class="text-start">Key</th>
                                <th class="text-start">Value</th>
                                <th class="text-start">Updated</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="td-strong">Webhook</td>
                                <td class="td-muted">Enabled</td>
                                <td class="td-muted">5 minutes ago</td>
                            </tr>
                            <tr>
                                <td class="td-strong">Notifications</td>
                                <td class="td-muted">Telegram + Email</td>
                                <td class="td-muted">1 hour ago</td>
                            </tr>
                            <tr>
                                <td class="td-strong">Theme</td>
                                <td class="td-muted">Light</td>
                                <td class="td-muted">Yesterday</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>

        {{-- Table with selection --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Selectable rows</h2>

            <div class="table-wrap">
                <div class="table-bar">
                    <div>
                        <p class="table-bar-title">Customers</p>
                        <p class="table-bar-subtitle">Bulk actions work great with checkboxes.</p>
                    </div>
                    <div class="table-bar-actions">
                        <button class="btn btn-secondary btn-sm">Export</button>
                        <button class="btn btn-danger btn-sm">Delete</button>
                    </div>
                </div>

                <div class="table-scroll">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th class="table-check">
                                    <input type="checkbox" aria-label="Select all">
                                </th>
                                <th class="text-start">Name</th>
                                <th class="text-start">Email</th>
                                <th class="text-start">Status</th>
                                <th class="text-end">Orders</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td class="table-check">
                                    <input type="checkbox" aria-label="Select row">
                                </td>
                                <td class="td-strong">John Doe</td>
                                <td class="td-muted">john@example.com</td>
                                <td><span class="badge badge-soft-success badge-dot">Active</span></td>
                                <td class="text-end td-strong">12</td>
                            </tr>

                            <tr>
                                <td class="table-check">
                                    <input type="checkbox" aria-label="Select row">
                                </td>
                                <td class="td-strong">Jane Smith</td>
                                <td class="td-muted">jane@example.com</td>
                                <td><span class="badge badge-soft-warning badge-dot">Pending</span></td>
                                <td class="text-end td-strong">3</td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>

        {{-- Empty state --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Empty state</h2>

            <div class="table-wrap">
                <div class="table-scroll">
                    <table class="table">
                        <thead>
                            <tr>
                                <th class="text-start">Order</th>
                                <th class="text-start">Customer</th>
                                <th class="text-start">Status</th>
                                <th class="text-end">Amount</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td colspan="4">
                                    <div class="table-empty">
                                        <p class="table-empty-title">No orders found</p>
                                        <p class="table-empty-text">When you start selling, new orders will appear here.</p>
                                        <div class="table-empty-actions">
                                            <button class="btn btn-primary btn-sm">Create test order</button>
                                            <button class="btn btn-secondary btn-sm">Learn more</button>
                                        </div>
                                    </div>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </section>

    </div>

</x-layouts.app>
