<x-layouts.app title="Headers">
    <div class="mx-auto max-w-6xl space-y-10 p-6">

        {{-- 1) Default header --}}
        <x-ui.page-header
            :title="__('Dashboard')"
            :subtitle="__('Track sales, orders, and customers in one place.')">
            <x-slot:actions>
                <button class="btn btn-secondary btn-sm">{{ __('Export') }}</button>
                <button class="btn btn-primary btn-sm">{{ __('New order') }}</button>
            </x-slot:actions>

            <x-slot:meta>
                <span>{{ __('Updated') }}: <span class="font-semibold text-slate-900">2 {{ __('min ago') }}</span></span>
                <span>{{ __('Environment') }}: <span class="font-semibold text-slate-900">Production</span></span>
            </x-slot:meta>
        </x-ui.page-header>

        {{-- 2) Card header with breadcrumbs --}}
        <x-ui.page-header
            variant="card"
            :title="__('Orders')"
            :subtitle="__('Review recent activity and manage fulfillment.')">
            <x-slot:breadcrumbs>
                <a href="#">{{ __('Home') }}</a>
                <span class="breadcrumbs-sep">/</span>
                <span class="text-slate-500">{{ __('Orders') }}</span>
            </x-slot:breadcrumbs>

            <x-slot:actions>
                <span class="badge badge-soft-success badge-dot">{{ __('Live') }}</span>
                <button class="btn btn-secondary btn-sm">{{ __('Filters') }}</button>
                <button class="btn btn-primary btn-sm">{{ __('Create') }}</button>
            </x-slot:actions>
        </x-ui.page-header>

        {{-- 3) Compact header (for inner pages) --}}
        <x-ui.page-header
            variant="compact"
            :title="__('Settings')"
            :subtitle="__('Manage integrations and payment methods.')">
            <x-slot:actions>
                <button class="btn btn-primary btn-sm">{{ __('Save changes') }}</button>
            </x-slot:actions>
        </x-ui.page-header>

        {{-- 4) Hero header (marketing / product) --}}
        <x-ui.page-header
            variant="hero"
            tone="soft"
            align="center"
            :title="__('Telegram Order Bot')"
            :subtitle="__('A bot + dashboard that automates ordering, payment, and notifications.')">
            <x-slot:actions>
                <button class="btn btn-primary">{{ __('Buy now') }}</button>
                <button class="btn btn-secondary">{{ __('See packages') }}</button>
            </x-slot:actions>

            <div class="mt-6 grid gap-3 sm:grid-cols-3">
                <div class="card">
                    <div class="card-body">
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Orders') }}</p>
                        <p class="mt-2 text-2xl font-semibold text-slate-900">1,248</p>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Customers') }}</p>
                        <p class="mt-2 text-2xl font-semibold text-slate-900">512</p>
                    </div>
                </div>
                <div class="card">
                    <div class="card-body">
                        <p class="text-xs font-semibold uppercase tracking-wide text-slate-600">{{ __('Revenue') }}</p>
                        <p class="mt-2 text-2xl font-semibold text-slate-900">€12,940</p>
                    </div>
                </div>
            </div>
        </x-ui.page-header>

        {{-- 5) Dark tone header with tabs --}}
        <x-ui.page-header
            variant="card"
            tone="dark"
            :title="__('Bot Admin')"
            :subtitle="__('Monitor webhooks, payments, and delivery status.')">
            <x-slot:actions>
                <button class="btn btn-secondary btn-sm">{{ __('Docs') }}</button>
                <button class="btn btn-primary btn-sm">{{ __('New integration') }}</button>
            </x-slot:actions>

            <x-slot:tabs>
                <a class="header-tab header-tab-active" href="#">{{ __('Overview') }}</a>
                <a class="header-tab" href="#">{{ __('Orders') }}</a>
                <a class="header-tab" href="#">{{ __('Products') }}</a>
                <a class="header-tab" href="#">{{ __('Settings') }}</a>
            </x-slot:tabs>
        </x-ui.page-header>

    </div>
</x-layouts.app>
