<x-layouts.app title="Forms">
    <div class="mx-auto max-w-5xl space-y-10 p-6">

        {{-- Basic inputs --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Basic inputs</h2>

            <div class="card">
                <div class="card-body space-y-4">

                    <div>
                        <label class="form-label form-required">Email</label>
                        <input class="form-control" type="email" placeholder="name@example.com">
                        <p class="form-help">We will never share your email.</p>
                    </div>

                    <div>
                        <label class="form-label">Password</label>
                        <input class="form-control" type="password" placeholder="••••••••">
                        <p class="form-hint">At least 8 characters.</p>
                    </div>

                    <div>
                        <label class="form-label">About</label>
                        <textarea class="form-control" placeholder="Write something..."></textarea>
                    </div>

                    <div>
                        <label class="form-label">Country</label>
                        <select class="form-control">
                            <option>Estonia</option>
                            <option>Germany</option>
                            <option>Iran</option>
                        </select>
                    </div>

                </div>
            </div>
        </section>

        {{-- Sizes --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Sizes</h2>

            <div class="card">
                <div class="card-body space-y-4">
                    <input class="form-control form-control-sm" placeholder="Small input">
                    <input class="form-control" placeholder="Default input">
                    <input class="form-control form-control-lg" placeholder="Large input">
                </div>
            </div>
        </section>

        {{-- Validation states --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Validation states</h2>

            <div class="card">
                <div class="card-body space-y-5">

                    <div>
                        <label class="form-label">Invalid</label>
                        <input class="form-control is-invalid" placeholder="Wrong value">
                        <p class="form-error">This field is required.</p>
                    </div>

                    <div>
                        <label class="form-label">Valid</label>
                        <input class="form-control is-valid" value="Looks good">
                        <p class="form-success">Perfect.</p>
                    </div>

                    <div>
                        <label class="form-label">Warning</label>
                        <input class="form-control is-warning" value="Potential issue">
                        <p class="form-help">Double check this value.</p>
                    </div>

                </div>
            </div>
        </section>

        {{-- Input group --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Input group (prefix/suffix)</h2>

            <div class="card">
                <div class="card-body space-y-4">

                    <div>
                        <label class="form-label">Website</label>
                        <div class="input-group">
                            <span class="input-addon input-addon-muted">https://</span>
                            <input class="form-control" placeholder="example.com">
                        </div>
                        <p class="form-help">A classic prefix group.</p>
                    </div>

                    <div>
                        <label class="form-label">Price</label>
                        <div class="input-group">
                            <span class="input-addon">€</span>
                            <input class="form-control" placeholder="99">
                            <span class="input-addon input-addon-muted">/ month</span>
                        </div>
                    </div>

                </div>
            </div>
        </section>

        {{-- Input with icons --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Input with icon inside</h2>

            <div class="card">
                <div class="card-body space-y-4">

                    <div>
                        <label class="form-label">Search</label>
                        <div class="input-icon has-end">
                            <span class="input-icon-start">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="2" stroke="currentColor" class="h-5 w-5">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M21 21l-4.35-4.35m1.35-5.15a7 7 0 11-14 0 7 7 0 0114 0z" />
                                </svg>
                            </span>

                            <input class="form-control" placeholder="Search products...">

                            <span class="input-icon-end">
                                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                    stroke-width="2" stroke="currentColor" class="h-5 w-5">
                                    <path stroke-linecap="round" stroke-linejoin="round"
                                        d="M6 18L18 6M6 6l12 12" />
                                </svg>
                            </span>
                        </div>
                    </div>

                </div>
            </div>
        </section>

        {{-- Checkbox / radio --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Checkbox & radio</h2>

            <div class="card">
                <div class="card-body space-y-5">

                    <div class="form-check">
                        <input class="form-check-input" type="checkbox" id="agree">
                        <div>
                            <label class="form-check-label" for="agree">I agree to the terms</label>
                            <p class="form-check-help">This is optional helper text.</p>
                        </div>
                    </div>

                    <div class="space-y-3">
                        <div class="form-check">
                            <input class="form-radio-input" type="radio" name="plan" id="plan1" checked>
                            <label class="form-check-label" for="plan1">Starter</label>
                        </div>

                        <div class="form-check">
                            <input class="form-radio-input" type="radio" name="plan" id="plan2">
                            <label class="form-check-label" for="plan2">Pro</label>
                        </div>
                    </div>

                </div>
            </div>
        </section>

        {{-- Switch --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Switch</h2>

            <div class="card">
                <div class="card-body">
                    <div class="flex items-center justify-between gap-4">
                        <div>
                            <p class="text-sm font-semibold text-slate-900">Enable notifications</p>
                            <p class="text-sm text-slate-600">Send alerts when orders are paid.</p>
                        </div>

                        <label class="switch">
                            <span class="switch-track"></span>
                            <input type="checkbox" checked>
                            <span class="switch-dot"></span>
                        </label>
                    </div>
                </div>
            </div>
        </section>

        {{-- File input --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">File input</h2>

            <div class="card">
                <div class="card-body space-y-2">
                    <label class="form-label">Upload document</label>
                    <input type="file" class="form-file">
                    <p class="form-help">PDF or image. Max 5MB.</p>
                </div>
            </div>
        </section>

        {{-- Fieldset --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Fieldset</h2>

            <fieldset class="form-fieldset">
                <legend class="form-legend">Billing</legend>

                <div class="mt-4 form-row">
                    <div>
                        <label class="form-label form-required">First name</label>
                        <input class="form-control" placeholder="John">
                    </div>
                    <div>
                        <label class="form-label form-required">Last name</label>
                        <input class="form-control" placeholder="Doe">
                    </div>
                </div>

                <div class="mt-4">
                    <label class="form-label">Address</label>
                    <input class="form-control" placeholder="Street, number, city">
                </div>

                <div class="mt-6 form-actions">
                    <button class="btn btn-secondary">Cancel</button>
                    <button class="btn btn-primary">Save</button>
                </div>
            </fieldset>
        </section>

    </div>
</x-layouts.app>
