<x-layouts.app title="Cards">

    <div class="mx-auto max-w-5xl space-y-10 p-6">

        {{-- Basic card --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Basic card</h2>

            <div class="card">
                <div class="card-body">
                    <p class="card-title">Card title</p>
                    <p class="card-subtitle">Card subtitle</p>
                    <p class="mt-4 card-text">
                        This is a basic card. Use it for simple content blocks.
                    </p>
                </div>
            </div>
        </section>

        {{-- Card with header + actions --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Card with header & actions</h2>

            <div class="card card-hover">
                <div class="card-header">
                    <div class="flex items-start gap-3">
                        <div class="card-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                                stroke-width="2" stroke="currentColor" class="h-5 w-5">
                                <path stroke-linecap="round" stroke-linejoin="round"
                                    d="M16.5 10.5V6.75a4.5 4.5 0 10-9 0v3.75m-.75 0h10.5A2.25 2.25 0 0119.5 12.75v6A2.25 2.25 0 0117.25 21H6.75A2.25 2.25 0 014.5 18.75v-6A2.25 2.25 0 016.75 10.5z" />
                            </svg>
                        </div>

                        <div>
                            <p class="card-title">Orders overview</p>
                            <p class="card-subtitle">A header with actions on the end side</p>
                        </div>
                    </div>

                    <div class="card-actions">
                        <span class="badge badge-soft-success badge-dot">Live</span>
                        <button class="btn btn-secondary btn-sm">Export</button>
                        <button class="btn btn-primary btn-sm">New order</button>
                    </div>
                </div>

                <div class="card-body">
                    <p class="card-text">
                        This pattern is great for dashboards: title + subtitle + actions.
                    </p>
                </div>

                <div class="card-footer">
                    <div class="flex flex-wrap items-center justify-between gap-3">
                        <p class="text-sm text-slate-600">Last updated: 2 minutes ago</p>
                        <button class="btn btn-soft-primary btn-sm">Refresh</button>
                    </div>
                </div>
            </div>
        </section>

        {{-- Soft card --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Soft card</h2>

            <div class="card card-soft">
                <div class="card-body">
                    <p class="card-title">Soft background</p>
                    <p class="card-subtitle">Use this to reduce contrast in dense layouts</p>
                </div>
            </div>
        </section>

        {{-- Stats cards --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Stats cards</h2>

            <div class="grid gap-4 sm:grid-cols-2 lg:grid-cols-4">
                <div class="card">
                    <div class="card-body">
                        <div class="stat">
                            <p class="stat-label">Total orders</p>
                            <p class="stat-value">1,248</p>
                            <p class="stat-hint">All-time</p>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="stat">
                            <p class="stat-label">Paid orders</p>
                            <p class="stat-value">986</p>
                            <p class="stat-hint">Fulfillable</p>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="stat">
                            <p class="stat-label">Customers</p>
                            <p class="stat-value">512</p>
                            <p class="stat-hint">Unique buyers</p>
                        </div>
                    </div>
                </div>

                <div class="card">
                    <div class="card-body">
                        <div class="stat">
                            <p class="stat-label">Revenue</p>
                            <p class="stat-value">€12,940</p>
                            <p class="stat-hint">Paid</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        {{-- Card list --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Card list</h2>

            <div class="card">
                <div class="card-header">
                    <div>
                        <p class="card-title">Recent orders</p>
                        <p class="card-subtitle">A list inside a card with divider items</p>
                    </div>
                    <div class="card-actions">
                        <button class="btn btn-secondary btn-sm">View all</button>
                    </div>
                </div>

                <div class="card-body p-0">
                    <div class="card-list">

                        <div class="card-list-item">
                            <div>
                                <p class="card-list-title">Order #3842</p>
                                <p class="card-list-subtitle">2 hours ago</p>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="badge badge-soft-success badge-dot">Paid</span>
                                <button class="btn btn-soft-primary btn-sm">Open</button>
                            </div>
                        </div>

                        <div class="card-list-item">
                            <div>
                                <p class="card-list-title">Order #3843</p>
                                <p class="card-list-subtitle">Yesterday</p>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="badge badge-soft-warning badge-dot">Awaiting</span>
                                <button class="btn btn-soft-primary btn-sm">Open</button>
                            </div>
                        </div>

                        <div class="card-list-item">
                            <div>
                                <p class="card-list-title">Order #3844</p>
                                <p class="card-list-subtitle">Last week</p>
                            </div>
                            <div class="flex items-center gap-2">
                                <span class="badge badge-soft-danger badge-dot">Failed</span>
                                <button class="btn btn-soft-primary btn-sm">Open</button>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </section>

        {{-- Empty state --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Empty state inside card</h2>

            <div class="card">
                <div class="card-header">
                    <div>
                        <p class="card-title">Products</p>
                        <p class="card-subtitle">When no data exists, show a helpful empty state</p>
                    </div>
                </div>

                <div class="card-body">
                    <div class="empty">
                        <p class="empty-title">No products yet</p>
                        <p class="empty-text">Create your first product package to start selling.</p>

                        <div class="empty-actions">
                            <button class="btn btn-primary btn-sm">Add product</button>
                            <button class="btn btn-secondary btn-sm">Learn more</button>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </div>

</x-layouts.app>
