<x-layouts.app title="Buttons">

    <div class="mx-auto max-w-4xl space-y-10 p-6">

        {{-- Basic --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Basic buttons</h2>
            <div class="flex flex-wrap gap-3">
                <button class="btn btn-primary">Primary</button>
                <button class="btn btn-secondary">Secondary</button>
                <button class="btn btn-success">Success</button>
                <button class="btn btn-danger">Danger</button>
                <button class="btn btn-warning">Warning</button>
            </div>
        </section>

        {{-- Sizes --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Sizes</h2>
            <div class="flex flex-wrap items-center gap-3">
                <button class="btn btn-primary btn-xs">Extra small</button>
                <button class="btn btn-primary btn-sm">Small</button>
                <button class="btn btn-primary">Default</button>
                <button class="btn btn-primary btn-lg">Large</button>
                <button class="btn btn-primary btn-xl">Extra large</button>
            </div>
        </section>

        {{-- Outline --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Outline</h2>
            <div class="flex gap-3">
                <button class="btn btn-outline-primary">Outline primary</button>
                <button class="btn btn-outline-danger">Outline danger</button>
            </div>
        </section>

        {{-- Soft --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Soft buttons</h2>
            <div class="flex gap-3">
                <button class="btn btn-soft-primary">Soft primary</button>
                <button class="btn btn-soft-danger">Soft danger</button>
            </div>
        </section>

        {{-- Icons --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">With icons</h2>
            <div class="flex gap-3">
                <button class="btn btn-primary">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke-width="2" stroke="currentColor" class="h-4 w-4">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M12 4v16m8-8H4" />
                    </svg>
                    Add item
                </button>

                <button class="btn btn-danger">
                    Delete
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke-width="2" stroke="currentColor" class="h-4 w-4">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7" />
                    </svg>
                </button>
            </div>
        </section>

        {{-- Icon only --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Icon only</h2>
            <button class="btn btn-secondary btn-icon">
                <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                    stroke-width="2" stroke="currentColor" class="h-5 w-5">
                    <path stroke-linecap="round" stroke-linejoin="round"
                        d="M6 18L18 6M6 6l12 12" />
                </svg>
            </button>
        </section>

        {{-- Loading --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Loading</h2>
            <button class="btn btn-primary btn-loading">
                Saving
            </button>
        </section>

        {{-- Block --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Block button</h2>
            <button class="btn btn-primary btn-block">
                Continue
            </button>
        </section>

        {{-- Disabled --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Disabled</h2>
            <button class="btn btn-primary" disabled>
                Disabled
            </button>
        </section>

    </div>

</x-layouts.app>
