<x-layouts.app title="Badges">

    <div class="mx-auto max-w-4xl space-y-10 p-6">

        {{-- Basic --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Basic badges</h2>
            <div class="flex flex-wrap gap-3">
                <span class="badge badge-primary">Primary</span>
                <span class="badge badge-secondary">Secondary</span>
                <span class="badge badge-success">Success</span>
                <span class="badge badge-danger">Danger</span>
                <span class="badge badge-warning">Warning</span>
                <span class="badge badge-info">Info</span>
            </div>
        </section>

        {{-- Soft --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Soft badges (dashboard friendly)</h2>
            <div class="flex flex-wrap gap-3">
                <span class="badge badge-soft-primary">Soft primary</span>
                <span class="badge badge-soft-success">Soft success</span>
                <span class="badge badge-soft-danger">Soft danger</span>
                <span class="badge badge-soft-warning">Soft warning</span>
                <span class="badge badge-soft-info">Soft info</span>
            </div>
        </section>

        {{-- Outline --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Outline badges</h2>
            <div class="flex flex-wrap gap-3">
                <span class="badge badge-outline-primary">Outline primary</span>
                <span class="badge badge-outline-danger">Outline danger</span>
            </div>
        </section>

        {{-- Sizes --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Sizes</h2>
            <div class="flex flex-wrap items-center gap-3">
                <span class="badge badge-soft-primary badge-sm">Small</span>
                <span class="badge badge-soft-primary">Default</span>
                <span class="badge badge-soft-primary badge-lg">Large</span>
            </div>
        </section>

        {{-- Dot / status --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Dot status badges</h2>
            <div class="flex flex-wrap gap-3">
                <span class="badge badge-soft-success badge-dot">Online</span>
                <span class="badge badge-soft-warning badge-dot">Pending</span>
                <span class="badge badge-soft-danger badge-dot">Failed</span>
                <span class="badge badge-soft-info badge-dot">Processing</span>
            </div>
        </section>

        {{-- With icon --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Badges with icon</h2>

            <div class="flex flex-wrap gap-3">

                <span class="badge badge-soft-success">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke-width="2" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M9 12.75L11.25 15 15 9.75" />
                    </svg>
                    Verified
                </span>

                <span class="badge badge-soft-warning">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke-width="2" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M12 9v3.75m0 3h.008M10.5 3.75h3L21 18.75H3L10.5 3.75z" />
                    </svg>
                    Needs review
                </span>

                <span class="badge badge-soft-danger">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24"
                        stroke-width="2" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round"
                            d="M6 18L18 6M6 6l12 12" />
                    </svg>
                    Blocked
                </span>

            </div>
        </section>

        {{-- Example in tables --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Example usage in a list</h2>

            <div class="overflow-hidden rounded-2xl border border-slate-200 bg-white">
                <div class="grid grid-cols-12 bg-slate-50 px-4 py-3 text-xs font-semibold uppercase tracking-wide text-slate-600">
                    <div class="col-span-6">Item</div>
                    <div class="col-span-6">Status</div>
                </div>

                <div class="grid grid-cols-12 items-center border-t border-slate-200 px-4 py-4">
                    <div class="col-span-6 text-sm font-semibold text-slate-900">Order #3842</div>
                    <div class="col-span-6">
                        <span class="badge badge-soft-success badge-dot">Paid</span>
                    </div>
                </div>

                <div class="grid grid-cols-12 items-center border-t border-slate-200 px-4 py-4">
                    <div class="col-span-6 text-sm font-semibold text-slate-900">Order #3843</div>
                    <div class="col-span-6">
                        <span class="badge badge-soft-warning badge-dot">Awaiting payment</span>
                    </div>
                </div>

                <div class="grid grid-cols-12 items-center border-t border-slate-200 px-4 py-4">
                    <div class="col-span-6 text-sm font-semibold text-slate-900">Order #3844</div>
                    <div class="col-span-6">
                        <span class="badge badge-soft-danger badge-dot">Failed</span>
                    </div>
                </div>
            </div>
        </section>

    </div>

</x-layouts.app>
