<x-layouts.app title="Alerts">

    <div class="mx-auto max-w-4xl space-y-10 p-6">

        {{-- Soft alerts --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Soft alerts</h2>

            <div class="space-y-4">
                <div class="alert alert-soft-primary">
                    <div class="alert-row">
                        <svg class="alert-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M11.25 11.25l.041-.02a.75.75 0 011.063.852l-.708 2.836a.75.75 0 01-1.063.498l-.041-.02M12 8.25h.008" />
                        </svg>
                        <div>
                            <p class="alert-title">Heads up</p>
                            <p class="alert-text">This is a soft primary alert. Use it for neutral messages.</p>
                        </div>
                    </div>
                </div>

                <div class="alert alert-soft-success">
                    <div class="alert-row">
                        <svg class="alert-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M9 12.75L11.25 15 15 9.75" />
                        </svg>
                        <div>
                            <p class="alert-title">Success</p>
                            <p class="alert-text">Your changes were saved successfully.</p>
                        </div>
                    </div>
                </div>

                <div class="alert alert-soft-warning">
                    <div class="alert-row">
                        <svg class="alert-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 9v3.75m0 3h.008M10.5 3.75h3L21 18.75H3L10.5 3.75z" />
                        </svg>
                        <div>
                            <p class="alert-title">Warning</p>
                            <p class="alert-text">Something needs your attention before continuing.</p>
                        </div>
                    </div>
                </div>

                <div class="alert alert-soft-danger">
                    <div class="alert-row">
                        <svg class="alert-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12" />
                        </svg>
                        <div>
                            <p class="alert-title">Error</p>
                            <p class="alert-text">We could not complete your request. Please try again.</p>
                        </div>
                    </div>
                </div>

                <div class="alert alert-soft-info">
                    <div class="alert-row">
                        <svg class="alert-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M12 16.5v-6m0 0V7.5m0 3h.008" />
                        </svg>
                        <div>
                            <p class="alert-title">Info</p>
                            <p class="alert-text">This is informational content. It is not an error.</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        {{-- Solid alerts --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Solid alerts</h2>

            <div class="space-y-4">
                <div class="alert alert-solid-primary">
                    <p class="alert-title">Solid primary</p>
                    <p class="alert-text">Use solid alerts sparingly for high importance. <a href="#">Learn more</a></p>
                </div>

                <div class="alert alert-solid-success">
                    <p class="alert-title">Solid success</p>
                    <p class="alert-text">Payment was confirmed and the order is now processing.</p>
                </div>

                <div class="alert alert-solid-warning">
                    <p class="alert-title">Solid warning</p>
                    <p class="alert-text">Your subscription will expire soon. Please update billing info.</p>
                </div>

                <div class="alert alert-solid-danger">
                    <p class="alert-title">Solid danger</p>
                    <p class="alert-text">Action required: your webhook URL is failing.</p>
                </div>

                <div class="alert alert-solid-info">
                    <p class="alert-title">Solid info</p>
                    <p class="alert-text">We are currently performing scheduled maintenance.</p>
                </div>
            </div>
        </section>

        {{-- Outline alerts --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Outline alerts</h2>

            <div class="space-y-4">
                <div class="alert alert-outline-primary">
                    <p class="alert-title">Outline primary</p>
                    <p class="alert-text">Good for subtle notes without background color.</p>
                </div>

                <div class="alert alert-outline-danger">
                    <p class="alert-title">Outline danger</p>
                    <p class="alert-text">Use this when you want to highlight an error without a filled background.</p>
                </div>
            </div>
        </section>

        {{-- Dismissible example (Alpine optional) --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Dismissible alert (optional Alpine)</h2>

            <div x-data="{ open: true }" x-show="open" class="alert alert-soft-info">
                <button type="button" class="alert-dismiss" @click="open = false" aria-label="Dismiss">
                    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor" class="h-5 w-5">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M6 18L18 6M6 6l12 12"/>
                    </svg>
                </button>

                <div class="alert-row">
                    <svg class="alert-icon" xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="2" stroke="currentColor">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M12 16.5v-6m0 0V7.5m0 3h.008" />
                    </svg>
                    <div>
                        <p class="alert-title">Dismiss me</p>
                        <p class="alert-text">This alert can be closed using Alpine. If you don’t use Alpine, just remove x-data and the button.</p>
                        <div class="alert-actions">
                            <button class="btn btn-primary btn-sm">Action</button>
                            <button class="btn btn-secondary btn-sm">Cancel</button>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        {{-- Laravel validation example --}}
        <section>
            <h2 class="mb-4 text-lg font-semibold">Laravel validation example</h2>

            <div class="alert alert-soft-danger">
                <p class="alert-title">Please fix the following errors:</p>

                <ul class="alert-list">
                    <li>The email field is required.</li>
                    <li>The password must be at least 8 characters.</li>
                    <li>The phone number is invalid.</li>
                </ul>
            </div>

            {{-- Real Laravel usage:
            @if ($errors->any())
                <div class="alert alert-soft-danger">
                    <p class="alert-title">{{ __('Please fix the following errors:') }}</p>
                    <ul class="alert-list">
                        @foreach ($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif
            --}}
        </section>

    </div>

</x-layouts.app>
