<x-layouts.app :footer="false" header-type="minimal">
    <x-slot:style>
        <style>
            /* Clean scrollbars (no dependency) */
            .scrollbar-clean {
                scrollbar-width: thin;
                scrollbar-color: rgba(107, 114, 128, .45) transparent;
            }

            .scrollbar-clean::-webkit-scrollbar {
                width: 10px;
                height: 10px;
            }

            .scrollbar-clean::-webkit-scrollbar-track {
                background: transparent;
            }

            .scrollbar-clean::-webkit-scrollbar-thumb {
                background: rgba(107, 114, 128, .35);
                border-radius: 999px;
                border: 3px solid transparent;
                background-clip: content-box;
            }

            .scrollbar-clean::-webkit-scrollbar-thumb:hover {
                background: rgba(107, 114, 128, .55);
                border: 3px solid transparent;
                background-clip: content-box;
            }

            .dark .scrollbar-clean {
                scrollbar-color: rgba(156, 163, 175, .35) transparent;
            }

            .dark .scrollbar-clean::-webkit-scrollbar-thumb {
                background: rgba(156, 163, 175, .25);
                border: 3px solid transparent;
                background-clip: content-box;
            }

            .dark .scrollbar-clean::-webkit-scrollbar-thumb:hover {
                background: rgba(156, 163, 175, .40);
                border: 3px solid transparent;
                background-clip: content-box;
            }

            /* Avoid iOS overscroll glow weirdness */
            .overscroll-contain {
                overscroll-behavior: contain;
            }
        </style>
    </x-slot:style>

    @php
        $channel = request()->get('channel' , 'tvroyan');
        $embedUrl = "https://www.aparat.com/embed/live/$channel";
    @endphp

    @if(auth()->user()->isActive() && auth()->user()->hasAparatProfile())
        {{-- Main --}}
        <div x-data="livePage()" class="">
            <div class="max-w-[1500px] mx-auto  px-4 sm:px-6 lg:px-8 py-5 sm:py-6 lg:py-8">
                <div class="grid grid-cols-1 lg:grid-cols-12 gap-4 lg:gap-6 items-start">

                    {{-- Video --}}
                    <section class="lg:col-span-8">
                        <div class="rounded-2xl border border-gray-200 bg-white shadow-sm overflow-hidden dark:border-gray-800 dark:bg-gray-900">
                            <div class="p-4 sm:p-5 flex items-center justify-between gap-3 border-b border-gray-100 dark:border-gray-800">
                                <div class="min-w-0">
                                    <div class="flex items-center gap-2">
                                    <span class="inline-flex items-center gap-2 rounded-full px-2.5 py-1 text-xs font-medium bg-red-50 text-red-700 dark:bg-red-500/10 dark:text-red-300">
                                        <span class="h-2 w-2 rounded-full bg-red-500 animate-pulse"></span>
                                        {{ __('Live now') }}
                                    </span>
                                        <span class="text-sm text-gray-500 dark:text-gray-400 truncate">
                                        {{ __('Watch and chat with the community') }}
                                    </span>
                                    </div>
                                    <h1 class="mt-2 text-lg sm:text-xl font-semibold tracking-tight">
                                        {{ __('TvRoyan Live Stream') }}
                                    </h1>
                                </div>

                                <button type="button"
                                        class="inline-flex items-center gap-2 rounded-xl px-3 py-2 text-sm border border-gray-200 bg-white hover:bg-gray-50 dark:border-gray-800 dark:bg-gray-900 dark:hover:bg-gray-800"
                                        @click="toast('{{ __('Share link copied (demo)') }}')">
                                    <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                                        <path d="M15 8a3 3 0 1 0-2.83-4H12a3 3 0 0 0 3 3Z" stroke="currentColor" stroke-width="2"/>
                                        <path d="M9 13a3 3 0 1 0-2.83-4H6a3 3 0 0 0 3 3Z" stroke="currentColor" stroke-width="2"/>
                                        <path d="M18 20a3 3 0 1 0-2.83-4H15a3 3 0 0 0 3 3Z" stroke="currentColor" stroke-width="2"/>
                                        <path d="M8.7 11.7l6.6-3.4M8.7 12.3l6.6 3.4" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                    </svg>
                                    <span class="hidden sm:inline">{{ __('Share') }}</span>
                                </button>
                            </div>

                            <div class="p-4 sm:p-5">
                                @if(!empty($embedUrl))
                                    <div class="relative w-full overflow-hidden rounded-2xl bg-black/90">
                                        <div class="relative w-full" style="padding-top:56.25%;">
                                            <iframe
                                                class="absolute inset-0 h-full w-full"
                                                src="{{ $embedUrl }}"
                                                title="{{ __('Live video') }}"
                                                allow="autoplay; encrypted-media; picture-in-picture"
                                                allowfullscreen
                                                loading="lazy"
                                            ></iframe>
                                        </div>
                                    </div>
                                @else
                                    <div class="rounded-2xl border border-dashed border-gray-300 bg-gray-50 p-6 sm:p-10 text-center dark:border-gray-700 dark:bg-gray-900/40">
                                        <div class="mx-auto h-12 w-12 rounded-2xl bg-gray-900 text-white dark:bg-white dark:text-gray-900 flex items-center justify-center">
                                            <svg class="h-6 w-6" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                                                <path d="M12 9v6M9 12h6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                                <path d="M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" stroke="currentColor" stroke-width="2"/>
                                            </svg>
                                        </div>
                                        <h2 class="mt-4 text-base sm:text-lg font-semibold">{{ __('No live embed configured') }}</h2>
                                        <p class="mt-1 text-sm text-gray-600 dark:text-gray-400">
                                            {{ __('Please provide an embed URL to show the live video here.') }}
                                        </p>
                                        <p class="mt-3 text-xs text-gray-500 dark:text-gray-500">
                                            {{ __('Example: https://www.aparat.com/embed/live/tvroyan') }}
                                        </p>
                                    </div>
                                @endif
                            </div>
                        </div>


                        @if(false)
                            {{-- Fun rows --}}
                            <div class="mt-4 flex flex-col gap-3">
                                <div class="flex items-center justify-between">
                                    <div class="text-xs font-medium text-gray-600 dark:text-gray-300">{{ __('Top fans') }}</div>
                                    <button type="button"
                                            class="text-xs text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200"
                                            @click="toast('{{ __('Fan list (demo)') }}')">
                                        {{ __('View') }}
                                    </button>
                                </div>

                                @php
                                    $fans = [
                                        ['name' => 'Ava', 'badge' => '🥇'],
                                        ['name' => 'Hadi', 'badge' => '🥈'],
                                        ['name' => 'Nima', 'badge' => '🥉'],
                                        ['name' => 'Sara', 'badge' => '⭐'],
                                    ];
                                @endphp

                                <div class="flex items-center gap-2 overflow-x-auto pb-1 scrollbar-clean">
                                    @foreach($fans as $fan)
                                        <div class="shrink-0 flex items-center gap-2 rounded-2xl border border-gray-200 bg-gray-50 px-3 py-2 dark:border-gray-800 dark:bg-gray-950">
                                            <div class="h-8 w-8 rounded-xl bg-gray-900 text-white dark:bg-white dark:text-gray-900 flex items-center justify-center text-xs font-semibold">
                                                {{ mb_substr($fan['name'], 0, 1) }}
                                            </div>
                                            <div class="leading-tight">
                                                <div class="text-xs font-semibold flex items-center gap-1">
                                                    <span>{{ $fan['name'] }}</span>
                                                    <span aria-hidden="true">{{ $fan['badge'] }}</span>
                                                </div>
                                                <div class="text-[11px] text-gray-500 dark:text-gray-400">{{ __('Supporter') }}</div>
                                            </div>
                                        </div>
                                    @endforeach
                                </div>
                            </div>
                        @endif
                    </section>

                    {{-- Chat (fixed height + clean scrollbar + emoji opens upward) --}}
                    <aside class="lg:col-span-4">
                        {{-- The chat card is made "sticky" on desktop to feel app-like --}}
                        <div class="lg:sticky lg:top-20">

                            <div class="rounded-2xl border border-gray-200 bg-white shadow-sm dark:border-gray-800 dark:bg-gray-900 overflow-hidden
                                    flex flex-col
                                    h-[calc(100vh-9.5rem)] lg:h-[calc(100vh-11rem)] min-h-[520px] max-h-[800px]">
                                {{-- Chat header --}}

                                <div class="p-4 sm:p-5 border-b border-gray-100 dark:border-gray-800 shrink-0">
                                    <div class="flex items-start justify-between gap-3">
                                        <div class="min-w-0">
                                            <div class="flex items-center gap-2">
                                                <h2 class="text-base font-semibold tracking-tight truncate">
                                                    گفت و گوی زنده
                                                </h2>
                                            </div>
                                            <p class="mt-1 text-xs text-gray-500 dark:text-gray-400">
                                                به اولین نسخه چت آپارات رویان خوش آمدید
                                            </p>
                                        </div>

                                        <div class="flex items-center gap-2">

                                        </div>
                                    </div>


                                </div>

                                {{-- Messages area (flex-1 so it never pushes beyond screen) --}}
                                <div class="px-4 sm:px-5 py-4 flex-1 min-h-0">
                                    <div class="rounded-2xl border border-gray-200 bg-gray-50 dark:border-gray-800 dark:bg-gray-950/40 overflow-hidden h-full">
                                        <div id="message-container" class="h-full overflow-y-auto scrollbar-clean overscroll-contain p-3 sm:p-4 space-y-3"
                                             x-ref="chatScroll">

                                            {{-- System message --}}
                                            <div class="flex justify-center border-b border-b-slate-700 pb-3">
                                                <div class=" rounded-xl border border-gray-200 bg-white px-3 py-2 text-xs text-gray-600 dark:border-gray-800 dark:bg-gray-900 dark:text-gray-300">
                                                    <div class="flex items-center justify-center gap-2">
                                                    <span class="shrink-0 inline-flex items-center justify-center h-6 w-6 rounded-xl bg-gray-900 text-white dark:bg-white dark:text-gray-900">
                                                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                                                            <path d="M12 22s8-4 8-10V6l-8-4-8 4v6c0 6 8 10 8 10Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                                            <path d="M9 12l2 2 4-4" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                                        </svg>
                                                    </span>
                                                        <span>
                                                        خوش آمدید! لطفا از هرگونه بحث های سیاسی و نامرتبط، بی احترامی و اسپم پرهیز کنید.
                                                    </span>
                                                    </div>
                                                </div>
                                            </div>


                                        </div>
                                    </div>
                                </div>

                                <div class="p-3 border-t border-gray-100 dark:border-gray-800 shrink-0">
                                    <div class="relative">
                                        <div class="absolute z-30 start-0 end-0 bottom-full mb-2"
                                             x-show="emojiOpen"
                                             x-transition
                                             @click.outside="emojiOpen=false">
                                            <div class="rounded-2xl border border-gray-200 bg-white p-3 shadow-xl dark:border-gray-800 dark:bg-gray-900">
                                                <div class="flex items-center justify-between mb-2">
                                                    <div class="text-xs font-medium text-gray-600 dark:text-gray-300">{{ __('Pick an emoji') }}</div>
                                                    <button type="button"
                                                            class="text-xs text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-200"
                                                            @click="emojiOpen=false">
                                                        {{ __('Close') }}
                                                    </button>
                                                </div>

                                                <div class="max-h-40 overflow-y-auto scrollbar-clean">
                                                    <div class="grid grid-cols-10 gap-1">
                                                        <template x-for="e in emojis" :key="e">
                                                            <button type="button"
                                                                    class="h-9 w-9 rounded-xl hover:bg-gray-100 dark:hover:bg-gray-800 text-lg"
                                                                    @click="addEmoji(e)"
                                                                    x-text="e"
                                                                    aria-label="{{ __('Insert emoji') }}"></button>
                                                        </template>
                                                    </div>
                                                </div>

                                                <div class="mt-3 text-[11px] text-gray-500 dark:text-gray-400">
                                                </div>
                                            </div>
                                        </div>

                                        <div class="flex items-end gap-2">

                                            <div class="flex-1">
                                                <label class="sr-only" for="chatMessage">{{ __('Message') }}</label>

                                                <div class="flex items-center rounded-xl border border-gray-200 bg-white dark:border-gray-800 dark:bg-gray-900 focus-within:ring-2 focus-within:ring-gray-900/10 dark:focus-within:ring-white/10">
                                                    <input
                                                        type="text"
                                                        id="chatMessage"
                                                        class="w-full  h-10 resize-none bg-transparent px-3 py-2 text-sm outline-none placeholder:text-gray-400 dark:placeholder:text-gray-500"
                                                        :placeholder="placeholderText"
                                                        x-model="message"
                                                        @keydown.enter.prevent="sendChat()"
                                                        maxlength="240"
                                                    />

                                                    <div class="flex items-center justify-between px-2">
                                                        <div class="flex items-center gap-1">
                                                            <button type="button"
                                                                    class="inline-flex items-center justify-center h-8 w-8 rounded-lg hover:bg-gray-100 dark:hover:bg-gray-800"
                                                                    @click="emojiOpen = !emojiOpen"
                                                                    :aria-expanded="emojiOpen.toString()"
                                                                    aria-label="{{ __('Emoji') }}">
                                                                <svg class="h-5 w-5" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                                                                    <path d="M8 14s1.5 2 4 2 4-2 4-2" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                                                                    <path d="M9 9h.01M15 9h.01" stroke="currentColor" stroke-width="3" stroke-linecap="round"/>
                                                                    <path d="M21 12a9 9 0 1 1-18 0 9 9 0 0 1 18 0Z" stroke="currentColor" stroke-width="2"/>
                                                                </svg>
                                                            </button>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>

                                            <button type="button"
                                                    class="shrink-0 inline-flex items-center justify-center h-10 px-4 rounded-xl bg-gray-900 text-white hover:opacity-90 disabled:opacity-50 disabled:cursor-not-allowed dark:bg-white dark:text-gray-900"
                                                    :disabled="message.trim().length === 0 || message.length > maxChars"
                                                    @click="sendChat()">
                                                <span class="text-sm font-semibold">{{ __('Send') }}</span>
                                                <svg class="ms-2 h-4 w-4" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                                                    <path d="M3 11.5l18-8-8 18-2-7-8-3Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                                </svg>
                                            </button>
                                        </div>

                                        <div class="mt-3">
                                            <div x-show="toastMessage" x-transition.opacity class="text-xs text-gray-600 dark:text-gray-300">
                                            <span class="inline-flex items-center gap-2 rounded-full border border-gray-200 bg-gray-50 px-3 py-1.5 dark:border-gray-800 dark:bg-gray-950">
                                                <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" aria-hidden="true">
                                                    <path d="M12 22s8-4 8-10V6l-8-4-8 4v6c0 6 8 10 8 10Z" stroke="currentColor" stroke-width="2" stroke-linejoin="round"/>
                                                </svg>
                                                <span x-text="toastMessage"></span>
                                            </span>
                                            </div>
                                        </div>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </aside>

                </div>
            </div>
        </div>
    @else
        <section class="max-w-3xl mx-auto mt-5">
            <x-ui.card>

                <div class="p-2">
                    <div class="alert alert-outline-primary">
                        <p class="alert-title">
                            برای استفاده از سرویس لایو و چت باید حساب آپارات داشته باشید. لطفا نام کاربری آپارات خود را وارد فرم زیر کرده و بر روی دکمه همگام سازی کلیک کنید
                        </p>
                    </div>
                </div>
                <livewire:sync-with-aparat/>
            </x-ui.card>
        </section>
    @endif

    <x-slot:script>
        <script src="{{ url('assets/js/socket.io/socket.io.js') }}"></script>
        <script>
            function livePage() {
                return {
                    socket: null,

                    mobileNavOpen: false,
                    reactionsOpen: true,
                    emojiOpen: false,

                    message: '',
                    maxChars: 240,

                    someoneTyping: false,
                    typingTimer: null,

                    connectedLabel: 'Online 0',
                    placeholderText: '{{ __('Write a message...') }}',

                    reactionChips: ['🔥', '❤️', '😂', '👏'],
                    emojis: ['😀', '😄', '😁', '😅', '😂', '🤣', '😍', '😘', '😎', '🤩', '🤔', '😴', '😭', '😡', '👍', '👏', '🔥', '❤️', '🎉', '✨', '🙌', '🤝', '😮', '😬', '😇', '🥳', '🤖', '💡', '🧠', '⚡'],

                    toastMessage: '',
                    toastTimer: null,

                    async init() {
                        await this.connect()

                        // Restore dark mode preference (UI-only)
                        try {
                            const saved = localStorage.getItem('tr_dark');
                            if (saved === '1') document.documentElement.classList.add('dark');
                        } catch (e) {
                        }

                        // Subtle typing indicator demo
                        setInterval(() => {
                            this.someoneTyping = Math.random() > 0.92;
                            if (this.someoneTyping) setTimeout(() => this.someoneTyping = false, 1200);
                        }, 2000);
                    },


                    onTyping() {
                        clearTimeout(this.typingTimer);
                        this.typingTimer = setTimeout(() => {
                        }, 250);
                    },

                    addEmoji(e) {
                        if (this.message.length >= this.maxChars) return;
                        this.message = (this.message + e).slice(0, this.maxChars);
                        this.emojiOpen = false;
                    },

                    sendChat() {
                        // UI-only placeholder; no realtime chat here.
                        const text = this.message.trim();
                        if (!text) return;

                        if (!this.requireSocket()) return;


                        this.socket.emit("send-message", {
                            sender: `{{auth()->user()->username ?? auth()->user()->name ?? '' }}`,
                            text: text,
                            image: `{{ auth()->user()->aparat_profile['pic_s'] ?? '' }}`,
                            platform: "tvroyan.com",
                        });
                        this.toast('{{ __('Message sent .') }}');

                        // Placeholder for future network send:
                        // this.postMessage(text);

                        this.message = '';
                        this.emojiOpen = false;
                    },
                    receivedChat(username, text, img = '') {

                        const wrap = document.createElement("div");
                        const container = document.getElementById("message-container");
                        wrap.className = "flex items-end gap-2";

                        const profile_image = document.createElement("img");
                        profile_image.setAttribute('src', img);
                        profile_image.className = "w-5 h-5 rounded-full";

                        const name = document.createElement("span");
                        name.className = "text-xs";
                        name.textContent = `${String(username ?? "Unknown")}: `;

                        const msg = document.createElement("div");
                        msg.className = "text-xs";
                        msg.textContent = String(text ?? "");

                        if (img !== '') {
                            wrap.appendChild(profile_image);
                        }
                        wrap.appendChild(name);
                        wrap.appendChild(msg);

                        container.appendChild(wrap);
                        container.scrollTop = container.scrollHeight;
                    },

                    async postMessage(text) {
                        try {
                            const response = await fetch('/api/live-chat/messages', {
                                method: 'POST',
                                headers: {
                                    'Content-Type': 'application/json',
                                    'Accept': 'application/json',
                                    // 'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]').getAttribute('content'),
                                },
                                body: JSON.stringify({
                                    message: text,
                                    channel: 'tvroyan',
                                    sent_at: new Date().toISOString(),
                                }),
                            });

                            if (!response.ok) {
                                this.toast('{{ __('Failed to send.') }}');
                                return;
                            }
                            // const data = await response.json();
                        } catch (e) {
                            this.toast('{{ __('Network error.') }}');
                        }
                    },

                    toast(msg) {
                        this.toastMessage = msg;
                        clearTimeout(this.toastTimer);
                        this.toastTimer = setTimeout(() => this.toastMessage = '', 2200);
                    },

                    // socket related code
                    log(line, obj) {
                        const ts = new Date().toISOString();
                        let out = `[${ts}] ${line}`;
                        if (obj !== undefined) {
                            try {
                                out += " " + JSON.stringify(obj);
                            } catch {
                                out += " " + String(obj);
                            }
                        }
                        console.log(out)
                    },
                    requireSocket() {
                        if (!this.socket || !this.socket.connected) {
                            this.log("⚠ not connected");
                            return false;
                        }
                        return true;
                    },

                    joinChannel() {
                        if (!this.requireSocket()) {
                            this.log("➡ join-channel : faild")
                            return;
                        }
                        const payload = {
                            channel: `tvroyan:channel-{{ request()->get('channel','tvroyan') }}`,
                            userId: `{{auth()->user()->id}}`
                        };
                        this.socket.emit("join-channel", payload);
                    },
                    async connect() {
                        if (this.socket && this.socket.connected) return;

                        const url = "http://127.0.0.1:4001";
                        const token = "";

                        this.socket = io(url, {
                            transports: ["websocket", "polling"],
                            auth: token ? {token} : {},
                            withCredentials: true,
                        });

                        this.socket.on("connect", () => {
                            this.joinChannel()
                        });

                        this.socket.on("disconnect", (reason) => {
                        });

                        this.socket.on("connect_error", (err) => {
                            this.log("❌ connect_error", {message: err && err.message ? err.message : String(err)});
                        });
                        this.socket.on("receive-message", (data) => {
                            this.receivedChat(data.sender, data.text, data.image)
                        });
                        this.socket.on("user-connected", (data) => {
                            this.connectedLabel = `Online ${data.totalConnected} `;
                        });
                        // Incoming events
                        const incoming = ["", "channel-message-received", "user-disconnected", "user-joined-channel", "user-left-channel", "identified", "pong", "server-shutting-down", "custom-event", "error"];

                        incoming.forEach((ev) => {
                            this.socket.on(ev, (payload) => this.log("⬅ " + ev, payload));
                        });
                    }
                }
            }
        </script>
    </x-slot:script>
</x-layouts.app>


