<x-layouts.app>

    <!-- Hero -->
    <section class="mx-auto max-w-6xl px-4 pt-10 pb-6">
        <div class="grid gap-6 lg:grid-cols-2 items-stretch">

            <div class="rounded-3xl border border-slate-200 bg-white p-7 transition-colors dark:border-white/10 dark:bg-black/20">
                <div class="inline-flex items-center gap-2 rounded-full border px-3 py-1 text-xs transition-colors
                        border-slate-200 bg-slate-900/5 text-slate-700
                        dark:border-white/10 dark:bg-black/20 dark:text-slate-300">
                <span class="h-2 w-2 rounded-full
                             {{ ($live['is_live'] ?? false) ? 'bg-emerald-400' : 'bg-slate-400 dark:bg-slate-500' }}"></span>

                    <span>
                    {{ ($live['is_live'] ?? false) ? __('LIVE NOW') : __('Offline (daily live hours)') }}
                </span>
                </div>

                <h1 class="mt-4 text-3xl md:text-4xl font-semibold tracking-tight">
                    {{ __('Royan TV — live sessions for coding & 3D.') }}
                </h1>

                <p class="mt-3 leading-relaxed text-slate-700 dark:text-slate-300">
                    {{ __('We go live a few hours per day with practical learning, real projects, and community Q&A.') }}
                </p>

                <div class="mt-6 flex flex-wrap gap-3">
                    <a href="{{ url('/live') }}"
                       class="rounded-xl px-4 py-2 font-semibold transition-colors
                          bg-slate-900 text-white hover:bg-slate-800
                          dark:bg-white dark:text-slate-950 dark:hover:bg-slate-200">
                        {{ __('Watch Live') }}
                    </a>

                    <a href="#schedule"
                       class="rounded-xl border px-4 py-2 transition-colors
                          border-slate-200 bg-slate-900/5 text-slate-900 hover:bg-slate-900/10
                          dark:border-white/10 dark:bg-black/20 dark:text-slate-100 dark:hover:bg-white/10">
                        {{ __('Weekly Schedule') }}
                    </a>
                </div>

                <div class="mt-6 grid gap-3 text-sm sm:grid-cols-3">

                    <div class="rounded-2xl border p-4 transition-colors
                            border-slate-200 bg-slate-900/5
                            dark:border-white/10 dark:bg-black/20">
                        <div class="text-slate-600 dark:text-slate-400">{{ __('Status') }}</div>
                        <div class="mt-1 font-semibold">
                            {{ ($live['is_live'] ?? false) ? __('On Air') : __('Offline') }}
                        </div>
                    </div>

                    <div class="rounded-2xl border p-4 transition-colors
                            border-slate-200 bg-slate-900/5
                            dark:border-white/10 dark:bg-black/20">
                        <div class="text-slate-600 dark:text-slate-400">{{ __('Current Show') }}</div>
                        <div class="mt-1 font-semibold truncate">
                            {{ $live['title'] ?? '—' }}
                        </div>
                    </div>

                    <div class="rounded-2xl border p-4 transition-colors
                            border-slate-200 bg-slate-900/5
                            dark:border-white/10 dark:bg-black/20">
                        <div class="text-slate-600 dark:text-slate-400">{{ __('Viewers') }}</div>
                        <div class="mt-1 font-semibold">
                            {{ ($live['is_live'] ?? false) ? ($live['viewers'] ?? '—') : '—' }}
                        </div>
                    </div>

                </div>
            </div>

            <!-- Live card preview -->
            <div class="flex flex-col overflow-hidden rounded-3xl border border-slate-200 bg-white transition-colors dark:border-white/10 dark:bg-black/20">
                <div class="flex items-center justify-between border-b border-slate-200 p-4 transition-colors dark:border-white/10">
                    <div>
                        <div class="text-sm font-semibold">{{ __('Live Preview') }}</div>
                        <div class="text-xs text-slate-600 dark:text-slate-400">
                            {{ __('Open the full live page for video + chat.') }}
                        </div>
                    </div>

                    <a href="{{ url('/live') }}"
                       class="rounded-xl border px-3 py-2 text-sm transition-colors
                          border-slate-200 bg-slate-900/5 hover:bg-slate-900/10
                          dark:border-white/10 dark:bg-black/20 dark:hover:bg-white/10">
                        {{ __('Open') }}
                    </a>
                </div>

                <div class="grid flex-1 place-items-center p-6">
                    <div class="w-full max-w-md rounded-2xl border p-6 text-center transition-colors
                            border-slate-200 bg-slate-900/5
                            dark:border-white/10 dark:bg-black/20">
                        <div class="mx-auto grid h-12 w-12 place-items-center rounded-2xl border transition-colors
                                border-slate-200 bg-white
                                dark:border-white/10 dark:bg-white/10">
                            <svg class="h-6 w-6" viewBox="0 0 24 24" fill="none">
                                <path d="M10 8l6 4-6 4V8z" fill="currentColor" opacity="0.9"/>
                            </svg>
                        </div>

                        <div class="mt-4 font-semibold">
                            {{ ($live['is_live'] ?? false) ? __('We are live!') : __('Next live session soon') }}
                        </div>

                        <div class="mt-1 text-sm text-slate-600 dark:text-slate-400">
                            {{ __('Check the schedule below or open the live page.') }}
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </section>
    @if(false)

        <!-- Social + Channels -->
        <section class="mx-auto max-w-6xl px-4 py-6">
            <div class="grid gap-6 lg:grid-cols-2">

                {{-- Social --}}
                <div class="rounded-3xl border border-slate-200 bg-white p-6 transition-colors dark:border-white/10 dark:bg-black/20">
                    <h2 class="text-lg font-semibold">{{ __('Our Social Accounts') }}</h2>
                    <p class="mt-1 text-sm text-slate-600 dark:text-slate-400">
                        {{ __('Follow updates, highlights, and schedule changes.') }}
                    </p>

                    <div class="mt-5 grid gap-3 sm:grid-cols-2">
                        <a href="{{ $links['instagram'] ?? '#' }}"
                           class="rounded-2xl border border-slate-200 bg-slate-900/5 p-4 transition-colors hover:opacity-95 hover:bg-slate-900/10 dark:border-white/10 dark:bg-black/20 dark:hover:bg-white/10">
                            <div class="text-sm font-semibold">{{ __('Instagram') }}</div>
                            <div class="break-all text-xs text-slate-600 dark:text-slate-400">
                                {{ $links['instagram'] ?? '' }}
                            </div>
                        </a>

                        <a href="{{ $links['telegram'] ?? '#' }}"
                           class="rounded-2xl border border-slate-200 bg-slate-900/5 p-4 transition-colors hover:opacity-95 hover:bg-slate-900/10 dark:border-white/10 dark:bg-black/20 dark:hover:bg-white/10">
                            <div class="text-sm font-semibold">{{ __('Telegram') }}</div>
                            <div class="break-all text-xs text-slate-600 dark:text-slate-400">
                                {{ $links['telegram'] ?? '' }}
                            </div>
                        </a>

                        <a href="{{ $links['discord'] ?? '#' }}"
                           class="rounded-2xl border border-slate-200 bg-slate-900/5 p-4 transition-colors hover:opacity-95 hover:bg-slate-900/10 dark:border-white/10 dark:bg-black/20 dark:hover:bg-white/10">
                            <div class="text-sm font-semibold">{{ __('Discord') }}</div>
                            <div class="break-all text-xs text-slate-600 dark:text-slate-400">
                                {{ $links['discord'] ?? '' }}
                            </div>
                        </a>

                        {{-- No JS interaction (copy) anymore: just a normal link to live page --}}
                        <a href="{{ url('/live') }}"
                           class="rounded-2xl border border-slate-200 bg-slate-900/5 p-4 text-start transition-colors hover:opacity-95 hover:bg-slate-900/10 dark:border-white/10 dark:bg-black/20 dark:hover:bg-white/10">
                            <div class="text-sm font-semibold">{{ __('Share Live Link') }}</div>
                            <div class="text-xs text-slate-600 dark:text-slate-400">
                                {{ __('Open TV Royan live page link') }}
                            </div>
                        </a>
                    </div>
                </div>

                {{-- Channels --}}
                <div class="rounded-3xl border border-slate-200 bg-white p-6 transition-colors dark:border-white/10 dark:bg-black/20">
                    <h2 class="text-lg font-semibold">{{ __('Our Channels') }}</h2>
                    <p class="mt-1 text-sm text-slate-600 dark:text-slate-400">
                        {{ __('Watch on your favorite platform.') }}
                    </p>

                    <div class="mt-5 grid gap-3 sm:grid-cols-2">
                        <a href="{{ $links['aparat'] ?? '#' }}"
                           class="rounded-2xl border border-slate-200 bg-slate-900/5 p-4 transition-colors hover:opacity-95 hover:bg-slate-900/10 dark:border-white/10 dark:bg-black/20 dark:hover:bg-white/10">
                            <div class="text-sm font-semibold">{{ __('Aparat') }}</div>
                            <div class="text-xs text-slate-600 dark:text-slate-400">{{ __('Main channel') }}</div>
                        </a>

                        <a href="{{ $links['youtube'] ?? '#' }}"
                           class="rounded-2xl border border-slate-200 bg-slate-900/5 p-4 transition-colors hover:opacity-95 hover:bg-slate-900/10 dark:border-white/10 dark:bg-black/20 dark:hover:bg-white/10">
                            <div class="text-sm font-semibold">{{ __('YouTube') }}</div>
                            <div class="text-xs text-slate-600 dark:text-slate-400">{{ __('Clips + archives') }}</div>
                        </a>

                        <a href="{{ url('/live') }}"
                           class="rounded-2xl bg-slate-900 p-4 text-white transition-colors hover:opacity-95 hover:bg-slate-800 dark:bg-white dark:text-slate-950 dark:hover:bg-slate-200 sm:col-span-2">
                            <div class="text-sm font-semibold">{{ __('TVRoyan Live Page') }}</div>
                            <div class="text-xs opacity-80">{{ __('Video + chat in one place') }}</div>
                        </a>
                    </div>
                </div>

            </div>
        </section>

        <!-- Weekly Schedule -->
        <section id="schedule" class="mx-auto max-w-6xl px-4 py-6">
            <div class="rounded-3xl border border-slate-200 bg-white p-6 transition-colors dark:border-white/10 dark:bg-black/20">
                <div class="flex flex-col gap-3 sm:flex-row sm:items-end sm:justify-between">
                    <div>
                        <h2 class="text-lg font-semibold">{{ __('Weekly Schedule') }}</h2>
                        <p class="mt-1 text-sm text-slate-600 dark:text-slate-400">
                            {{ __('Program times and hosts (adjust anytime).') }}
                        </p>
                    </div>

                    {{-- Static (server-rendered) timestamp --}}
                    @if(!empty($liveLastCheckedAt))
                        <div class="text-xs text-slate-600 dark:text-slate-400">
                            {{ __('Live status updated:') }}
                            <span>{{ $liveLastCheckedAt }}</span>
                        </div>
                    @endif
                </div>

                {{-- No Alpine tabs. Render a simple table for the whole week (server-side) --}}
                <div class="mt-5 overflow-hidden rounded-2xl border border-slate-200 transition-colors dark:border-white/10">
                    <table class="w-full text-sm">
                        <thead class="bg-slate-900/5 text-slate-700 transition-colors dark:bg-black/20 dark:text-slate-300">
                        <tr>
                            <th class="w-40 px-4 py-3 text-start">{{ __('Day') }}</th>
                            <th class="w-28 px-4 py-3 text-start">{{ __('Time') }}</th>
                            <th class="px-4 py-3 text-start">{{ __('Program') }}</th>
                            <th class="w-48 px-4 py-3 text-start">{{ __('Host') }}</th>
                        </tr>
                        </thead>

                        <tbody class="divide-y divide-slate-200 dark:divide-white/10">
                        @forelse(($scheduleDays ?? []) as $day)
                            @if(!empty($day['items']))
                                @foreach($day['items'] as $item)
                                    <tr class="transition-colors hover:bg-slate-900/5 dark:hover:bg-white/5">
                                        <td class="px-4 py-3 font-medium">{{ $day['name'] ?? '' }}</td>
                                        <td class="px-4 py-3 text-slate-700 dark:text-slate-300">{{ $item['time'] ?? '' }}</td>
                                        <td class="px-4 py-3 font-medium">{{ $item['title'] ?? '' }}</td>
                                        <td class="px-4 py-3 text-slate-700 dark:text-slate-300">{{ $item['host'] ?? '' }}</td>
                                    </tr>
                                @endforeach
                            @else
                                <tr>
                                    <td class="px-4 py-3 font-medium">{{ $day['name'] ?? '' }}</td>
                                    <td colspan="3" class="px-4 py-3 text-slate-600 dark:text-slate-400">
                                        {{ __('No programs scheduled for this day yet.') }}
                                    </td>
                                </tr>
                            @endif
                        @empty
                            <tr>
                                <td colspan="4" class="px-4 py-6 text-center text-slate-600 dark:text-slate-400">
                                    {{ __('No schedule data available.') }}
                                </td>
                            </tr>
                        @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </section>

        <!-- Team -->
        <section id="team" class="mx-auto max-w-6xl px-4 py-6">
            <div class="rounded-3xl border border-slate-200 bg-white p-6 transition-colors dark:border-white/10 dark:bg-black/20">
                <h2 class="text-lg font-semibold">{{ __('Team') }}</h2>
                <p class="mt-1 text-sm text-slate-600 dark:text-slate-400">
                    {{ __('Meet the people behind Royan.') }}
                </p>

                <div class="mt-5 grid gap-4 sm:grid-cols-2 lg:grid-cols-3">
                    @foreach(($team ?? []) as $member)
                        @php
                            $name = $member['name'] ?? '';
                            $role = $member['role'] ?? '';
                            $bio  = $member['bio'] ?? '';
                            $initial = mb_substr($name, 0, 1);
                        @endphp

                        <div class="rounded-3xl border border-slate-200 bg-slate-900/5 p-5 transition-colors dark:border-white/10 dark:bg-black/20">
                            <div class="flex items-center gap-3">
                                <div class="grid h-11 w-11 place-items-center rounded-2xl border border-slate-200 bg-white transition-colors dark:border-white/10 dark:bg-white/10">
                                    <span class="font-semibold">{{ $initial }}</span>
                                </div>
                                <div>
                                    <div class="font-semibold">{{ $name }}</div>
                                    <div class="text-xs text-slate-600 dark:text-slate-400">{{ $role }}</div>
                                </div>
                            </div>
                            <p class="mt-4 text-sm leading-relaxed text-slate-700 dark:text-slate-300">
                                {{ $bio }}
                            </p>
                        </div>
                    @endforeach
                </div>
            </div>
        </section>

    @endif

    <!-- About + Contact (summary) -->
    <section class="mx-auto max-w-6xl px-4 py-6">
        <div class="grid gap-6 lg:grid-cols-2">
            <div class="rounded-3xl border border-slate-200 bg-white p-6 transition-colors dark:border-white/10 dark:bg-black/20">
                <h2 class="text-lg font-semibold">{{ __('About TV Royan') }}</h2>
                <p class="mt-2 text-sm leading-relaxed text-slate-700 dark:text-slate-300">
                    {{ __('TV Royan started as an Aparat live channel. We go live a few hours per day and focus on practical learning: coding, building real projects, and 3D modeling.') }}
                </p>

            </div>

            <div class="rounded-3xl border border-slate-200 bg-white p-6 transition-colors dark:border-white/10 dark:bg-black/20">
                <h2 class="text-lg font-semibold">{{ __('Contact Us') }}</h2>
                <p class="mt-2 text-sm leading-relaxed text-slate-700 dark:text-slate-300">
                    {{ __('Want to collaborate, sponsor a session, or join the team?') }}
                </p>
                <a href="{{ route('contact-us') }}"
                   class="mt-4 inline-flex rounded-xl bg-slate-900 px-3 py-2 font-semibold text-white transition-colors hover:bg-slate-800 dark:bg-white dark:text-slate-950 dark:hover:bg-slate-200">
                    {{ __('Contact') }}
                </a>
            </div>
        </div>
    </section>

</x-layouts.app>
