<x-layouts.app>
    <section class="max-w-3xl mx-auto px-4 py-10">
        <div
            class="rounded-2xl border border-slate-200 bg-white p-6 md:p-8
                   dark:border-slate-700 dark:bg-slate-900"
        >
            <div class="space-y-2">
                <h1 class="text-2xl font-semibold">
                    {{ __('Contact us') }}
                </h1>
                <p class="text-slate-600 dark:text-slate-400 leading-7">
                    خوشحال می‌شویم از شما بشنویم! اگر سوالی درباره خدمات ما دارید،
                    نیاز به پشتیبانی دارید یا فقط می‌خواهید بازخوردی ارائه دهید،
                    لطفاً با ما در تماس باشید.
                </p>
            </div>

            @if (session('success'))
                <div
                    class="mt-5 rounded-xl border px-4 py-3
                           border-emerald-200 bg-emerald-50 text-emerald-800
                           dark:border-emerald-400/30 dark:bg-emerald-900/20 dark:text-emerald-300"
                >
                    {{ session('success') }}
                </div>
            @endif

            @if ($errors->any())
                <div
                    class="mt-5 rounded-xl border px-4 py-3
                           border-rose-200 bg-rose-50 text-rose-800
                           dark:border-rose-400/30 dark:bg-rose-900/20 dark:text-rose-300"
                >
                    <div class="font-semibold">
                        {{ __('Please fix the following issues:') }}
                    </div>
                    <ul class="mt-2 list-disc pr-5 space-y-1">
                        @foreach ($errors->all() as $errorMessage)
                            <li>{{ $errorMessage }}</li>
                        @endforeach
                    </ul>
                </div>
            @endif

            <form class="mt-6 space-y-4" method="POST" action="{{ route('contact-us') }}">
                @csrf

                <div class="space-y-2">
                    <label for="name" class="text-sm font-medium">
                        {{ __('Name') }}
                    </label>
                    <input
                        id="name"
                        name="name"
                        type="text"
                        value="{{ old('name') }}"
                        class="w-full rounded-xl
                               border border-slate-200 bg-slate-50
                               px-4 py-3 text-right outline-none
                               focus:ring-4 focus:ring-slate-200
                               dark:border-slate-700 dark:bg-slate-800
                               dark:focus:ring-slate-700"
                        autocomplete="off"
                    />
                </div>

                <div class="space-y-2">
                    <label for="email" class="text-sm font-medium">
                        {{ __('Email') }}
                    </label>
                    <input
                        id="email"
                        name="email"
                        type="text"
                        value="{{ old('email') }}"
                        class="w-full rounded-xl
                               border border-slate-200 bg-slate-50
                               px-4 py-3 text-right outline-none
                               focus:ring-4 focus:ring-slate-200
                               dark:border-slate-700 dark:bg-slate-800
                               dark:focus:ring-slate-700"
                        autocomplete="off"
                    />
                </div>

                <div class="space-y-2">
                    <label for="subject" class="text-sm font-medium">
                        {{ __('Subject') }}
                    </label>
                    <input
                        id="subject"
                        name="subject"
                        type="text"
                        value="{{ old('subject') }}"
                        class="w-full rounded-xl
                               border border-slate-200 bg-slate-50
                               px-4 py-3 text-right outline-none
                               focus:ring-4 focus:ring-slate-200
                               dark:border-slate-700 dark:bg-slate-800
                               dark:focus:ring-slate-700"
                        autocomplete="off"
                    />
                </div>

                <div class="space-y-2">
                    <label for="message" class="text-sm font-medium">
                        {{ __('Message') }}
                    </label>
                    <textarea
                        id="message"
                        name="message"
                        rows="4"
                        class="w-full rounded-xl
                               border border-slate-200 bg-slate-50
                               px-4 py-3 text-right outline-none
                               focus:ring-4 focus:ring-slate-200
                               dark:border-slate-700 dark:bg-slate-800
                               dark:focus:ring-slate-700"
                    >{{ old('message') }}</textarea>
                </div>

                <div class="flex flex-col md:flex-row gap-3 pt-2">
                    <button
                        type="submit"
                        class="md:w-auto w-full rounded-xl px-6 py-3 font-medium
                               bg-slate-900 text-white hover:bg-slate-800
                               dark:bg-slate-100 dark:text-slate-900 dark:hover:bg-slate-200"
                    >
                        {{ __('Submit') }}
                    </button>

                    <a
                        href="{{ url('/') }}"
                        class="md:w-auto w-full rounded-xl px-6 py-3 text-center
                               border border-slate-200 bg-white hover:bg-slate-50
                               dark:border-slate-700 dark:bg-slate-900 dark:hover:bg-slate-800"
                    >
                        {{ __('Back') }}
                    </a>
                </div>
            </form>
        </div>
    </section>
</x-layouts.app>
