<x-layouts.app>
    <section class="p-4 md:p-10 space-y-4">
        <x-ui.card class="p-4">
            <x-admin.top-nav active="users" />
        </x-ui.card>

        @foreach($users as $user)
        <x-ui.card
            class="mb-3 p-4 flex flex-col sm:flex-row sm:items-center sm:justify-between
               gap-4 hover:bg-gray-50/60 dark:hover:bg-white/5 transition">
            {{-- User info --}}
            <div class="flex flex-col sm:flex-row sm:items-center gap-2 sm:gap-4">
                <div class="flex items-center gap-2">
                    <div class="h-9 w-9 rounded-full bg-gray-200 text-gray-700
                            flex items-center justify-center text-sm font-semibold
                            dark:bg-white/10 dark:text-white">
                        {{ strtoupper(substr($user->name, 0, 1)) }}
                    </div>

                    <div>
                        <p class="font-medium text-gray-900 dark:text-white">
                            {{ $user->name }}
                        </p>
                        <p class="text-xs text-gray-500 dark:text-white/60">
                            {{ $user->email }}
                        </p>
                    </div>
                </div>

                {{-- Role badge --}}
                @if($user->hasAnyRole(['admin', 'administrator']))
                <span class="inline-flex rounded-full px-3 py-1 text-xs font-semibold
                             bg-emerald-100 text-emerald-800
                             dark:bg-emerald-500/15 dark:text-emerald-300">
                    {{ __('Admin') }}
                </span>
                @endif
            </div>

            {{-- Actions --}}
            <div class="flex flex-wrap items-center justify-end gap-2">
                <button
                    type="button"
                    class="text-sm font-medium text-blue-600 hover:text-blue-700
                       dark:text-blue-400 dark:hover:text-blue-300">
                    {{ __('Show') }}
                </button>

                <a
                    href="{{ route('admin.users.edit', $user->id) }}"
                    class="text-sm font-medium text-gray-700 hover:text-gray-900
                       dark:text-white/80 dark:hover:text-white">
                    {{ __('Edit') }}
                </a>

                @if(!$user->hasAnyRole(['admin', 'administrator']))
                <form
                    method="POST"
                    action="{{ route('admin.users.destroy', $user->id) }}"
                    onsubmit="return confirm('{{ __('Are you sure?') }}')">
                    @csrf
                    @method('DELETE')

                    <button
                        type="submit"
                        class="text-sm font-medium text-red-600 hover:text-red-700
                               dark:text-red-400 dark:hover:text-red-300">
                        {{ __('Delete') }}
                    </button>
                </form>
                @endif
            </div>
        </x-ui.card>
        @endforeach

    </section>

</x-layouts.app>
