<x-layouts.app>
    <section class="p-4 md:p-10 space-y-4">

        <x-ui.card class="p-4">
            <x-admin.top-nav active="dashboard"/>
        </x-ui.card>

        {{-- Main --}}
        <div class="w-full flex flex-col gap-4">

            {{-- Top stats --}}
            <div class="grid grid-cols-1 sm:grid-cols-2 xl:grid-cols-4 gap-4">
                <x-ui.card class="p-4">
                    <p class="text-sm text-slate-500 dark:text-slate-400">
                        {{ __('Users') }}
                    </p>
                    <div class="mt-1 text-2xl font-semibold">{{ number_format($stats['users_total']) }}</div>
                </x-ui.card>

                <x-ui.card class="p-4">
                    <p class="text-sm text-slate-500 dark:text-slate-400">
                        {{ __('Pages') }}
                    </p>
                    <div class="mt-1 text-2xl font-semibold">

                    </div>
                    <div class="mt-1 text-xs text-slate-500 dark:text-slate-400">
                        {{ __('Added today:') }}
                    </div>
                </x-ui.card>

                <x-ui.card class="p-4">
                    <p class="text-sm text-slate-500 dark:text-slate-400">
                        {{ __('Domains') }}
                    </p>
                    <div class="mt-1 text-2xl font-semibold">

                    </div>
                </x-ui.card>

                <x-ui.card class="p-4">
                    <p class="text-sm text-slate-500 dark:text-slate-400">
                        {{ __('Crawl pending') }}
                    </p>
                    <div class="mt-1 text-2xl font-semibold">

                    </div>
                    <div class="mt-1 text-xs text-slate-500 dark:text-slate-400">
                        {{ __('Not reachable:') }}
                    </div>
                </x-ui.card>
            </div>

            {{-- Middle --}}
            <div class="grid grid-cols-1 xl:grid-cols-3 gap-4">
                <x-ui.card class="p-4 xl:col-span-2">
                    <div class="flex items-center justify-between gap-3">
                        <div class="text-base font-semibold">
                            {{ __('Crawl requests status') }}
                        </div>
                        <a
                            href="{{ route('admin.crawl-requests.index') }}"
                            class="text-sm text-slate-600 hover:text-slate-900
                                   dark:text-slate-400 dark:hover:text-slate-100"
                        >
                            {{ __('View all') }}
                        </a>
                    </div>

                    <div class="mt-4 space-y-2">
                        @forelse([] as $row)
                            <div class="flex items-center justify-between gap-3">
                                <div class="text-sm text-slate-700 dark:text-slate-300">

                                </div>
                                <div class="text-sm font-medium">

                                </div>
                            </div>
                        @empty
                            <div class="text-sm text-slate-500 dark:text-slate-400">
                                {{ __('No data') }}
                            </div>
                        @endforelse
                    </div>
                </x-ui.card>

                <x-ui.card class="p-4">
                    <div class="text-base font-semibold">
                        {{ __('Quick actions') }}
                    </div>

                    <div class="mt-4 flex flex-col gap-2">
                        <a
                            href=""
                            class="inline-flex items-center justify-center rounded-xl px-4 py-2
                                   text-sm font-medium
                                   bg-slate-900 text-white hover:bg-slate-800
                                   dark:bg-slate-100 dark:text-slate-900 dark:hover:bg-slate-200"
                        >
                            {{ __('Manage crawl requests') }}
                        </a>

                        <a
                            href=""
                            class="inline-flex items-center justify-center rounded-xl px-4 py-2
                                   text-sm font-medium
                                   bg-slate-100 text-slate-900 hover:bg-slate-200
                                   dark:bg-slate-800 dark:text-slate-100 dark:hover:bg-slate-700"
                        >
                            {{ __('Manage domains') }}
                        </a>

                        <a
                            href="{{ route('admin.settings.script-token') }}"
                            class="inline-flex items-center justify-center rounded-xl px-4 py-2
                                   text-sm font-medium
                                   bg-slate-100 text-slate-900 hover:bg-slate-200
                                   dark:bg-slate-800 dark:text-slate-100 dark:hover:bg-slate-700"
                        >
                            {{ __('Script token') }}
                        </a>
                    </div>
                </x-ui.card>
            </div>

            {{-- Bottom --}}


        </div>
    </section>
</x-layouts.app>
