<x-layouts.app>
    <section class="p-4 md:p-10 space-y-4">
        <x-ui.card class="p-4">
            <x-admin.top-nav active="contact" />
        </x-ui.card>

        @php
        $submissions = \App\Models\ContactMessage::all()
        @endphp

        <x-ui.card class="p-0 overflow-hidden">
            {{-- Header --}}
            <div class="px-4 sm:px-6 py-4 border-b border-gray-200/70 dark:border-white/10">
                <div class="flex items-center justify-between gap-3">
                    <div>
                        <h3 class="text-base font-semibold text-gray-900 dark:text-white">
                            {{ __('Contact submissions') }}
                        </h3>
                        <p class="text-xs text-gray-500 dark:text-white/60">
                            {{ __('Latest messages received from the website') }}
                        </p>
                    </div>

                    <div class="text-xs text-gray-500 dark:text-white/60">
                        {{ __('Total') }}: <span class="font-semibold text-gray-900 dark:text-white">{{ $submissions->count() }}</span>
                    </div>
                </div>
            </div>

            {{-- Table --}}
            <div class="overflow-x-auto">
                <table class="min-w-full text-sm">
                    <thead class="bg-gray-50 text-gray-600 dark:bg-white/5 dark:text-white/70">
                        <tr class="border-b border-gray-200/70 dark:border-white/10">
                            <th class="px-4 sm:px-6 py-3 text-left font-medium">{{ __('Name') }}</th>
                            <th class="px-4 sm:px-6 py-3 text-left font-medium">{{ __('Subject') }}</th>
                            <th class="px-4 sm:px-6 py-3 text-left font-medium">{{ __('Email') }}</th>
                            <th class="px-4 sm:px-6 py-3 text-right font-medium">{{ __('Message') }}</th>
                        </tr>
                    </thead>

                    <tbody class="divide-y divide-gray-200/70 dark:divide-white/10">
                        @forelse($submissions as $submission)
                        {{-- Row --}}
                        <tr class="bg-white hover:bg-gray-50/70 dark:bg-transparent dark:hover:bg-white/5">
                            <td class="px-4 sm:px-6 py-4 align-top">
                                <div class="font-medium text-gray-900 dark:text-white">
                                    {{ $submission->name }}
                                </div>
                            </td>

                            <td class="px-4 sm:px-6 py-4 align-top">
                                <div class="text-gray-900 dark:text-white">
                                    {{ $submission->subject }}
                                </div>
                            </td>

                            <td class="px-4 sm:px-6 py-4 align-top">
                                <a
                                    href="mailto:{{ $submission->email }}"
                                    class="text-blue-600 hover:text-blue-700 hover:underline dark:text-blue-400 dark:hover:text-blue-300">
                                    {{ $submission->email }}
                                </a>
                            </td>

                            <td class="px-4 sm:px-6 py-4 align-top text-right">
                                <button
                                    type="button"
                                    class="inline-flex items-center gap-2 rounded-lg px-3 py-1.5 text-xs font-medium
                                       bg-gray-100 text-gray-800 hover:bg-gray-200
                                       dark:bg-white/10 dark:text-white dark:hover:bg-white/15"
                                    x-data="{ open: false }"
                                    @click="open = !open">
                                    <span x-text="open ? '{{ __('Hide') }}' : '{{ __('View') }}'"></span>
                                    <span class="opacity-60">•</span>
                                    <span class="opacity-80">{{ __('Details') }}</span>

                                    {{-- Toggle row via event --}}
                                    <span class="sr-only">{{ __('Toggle message') }}</span>

                                    {{-- Small chevron --}}
                                    <svg class="w-4 h-4 transition" :class="open ? 'rotate-180' : ''" viewBox="0 0 20 20" fill="currentColor">
                                        <path fill-rule="evenodd" d="M5.23 7.21a.75.75 0 0 1 1.06.02L10 10.94l3.71-3.71a.75.75 0 1 1 1.06 1.06l-4.24 4.24a.75.75 0 0 1-1.06 0L5.21 8.29a.75.75 0 0 1 .02-1.08z" clip-rule="evenodd" />
                                    </svg>

                                    {{-- Control message row --}}
                                    <template x-effect="
                                    const row = $el.closest('tr');
                                    const details = row.nextElementSibling;
                                    if (details?.dataset?.detailsRow === '1') {
                                        details.classList.toggle('hidden', !open);
                                    }
                                "></template>
                                </button>
                            </td>
                        </tr>

                        {{-- Message row (hidden by default) --}}
                        <tr class="hidden bg-gray-50/60 dark:bg-white/5" data-details-row="1">
                            <td colspan="4" class="px-4 sm:px-6 py-4">
                                <div class="flex items-start gap-3">
                                    <div class="mt-0.5 inline-flex h-8 w-8 items-center justify-center rounded-full bg-blue-100 text-blue-700 dark:bg-blue-500/15 dark:text-blue-300">
                                        <svg class="w-4 h-4" viewBox="0 0 24 24" fill="currentColor">
                                            <path d="M20 4H4a2 2 0 0 0-2 2v12a2 2 0 0 0 2 2h14l4 4V6a2 2 0 0 0-2-2Zm-2 9H6v-2h12v2Zm0-3H6V8h12v2Z" />
                                        </svg>
                                    </div>

                                    <div class="w-full">
                                        <div class="flex items-center justify-between gap-3">
                                            <div class="text-xs font-semibold text-gray-700 dark:text-white/80">
                                                {{ __('User message') }}
                                            </div>
                                            @if(!empty($submission->created_at))
                                            <div class="text-xs text-gray-500 dark:text-white/60">
                                                {{ $submission->created_at->diffForHumans() }}
                                            </div>
                                            @endif
                                        </div>

                                        <p class="mt-2 text-sm leading-7 text-gray-800 dark:text-white/90 whitespace-pre-line">
                                            {{ $submission->message }}
                                        </p>
                                    </div>
                                </div>
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="4" class="px-4 sm:px-6 py-10 text-center text-sm text-gray-500 dark:text-white/60">
                                {{ __('No submissions found.') }}
                            </td>
                        </tr>
                        @endforelse
                    </tbody>
                </table>
            </div>

            {{-- Footer (optional pagination slot) --}}
            @if(method_exists($submissions, 'links'))
            <div class="px-4 sm:px-6 py-4 border-t border-gray-200/70 dark:border-white/10">
                {{ $submissions->links() }}
            </div>
            @endif
        </x-ui.card>

    </section>

</x-layouts.app>
