<?php

use Livewire\Volt\Component;

new class extends Component {

    public $aparat_username;

    public function syncWithAparat()
    {
        auth()->user()->update([
            'username' => $this->aparat_username,
            'aparat_username' => $this->aparat_username,
        ]);

        try {
            if (auth()->user()->updateApartProfile()) {

                return back();
            } else {
                session()->flash('error', 'عملیات با خطا مواجه شد');
            }
        } catch (Exception $exception) {
            session()->flash('error', 'عملیات با خطا مواجه شد');
        }
    }
}; ?>

<div>

    @session('error')
    <div class="alert alert-soft-danger">
        <div class="alert-row">
            <div>
                <p class="alert-title">{{ session('error') }}</p>
            </div>
        </div>
    </div>
    @endsession
    <div class="flex justify-start items-center gap-3 p-4">
        <div class="grow">
            <x-ui.form.input name="aparat_username" placeholder="نام کاربری شما در آپارات" wire/>
        </div>
        <button wire:click="syncWithAparat" class="btn btn-primary">
            همگام سازی
        </button>
    </div>




</div>
