<?php

use Livewire\Volt\Component;

new class extends Component {

    public function migrateDB()
    {
        dd(Artisan::call("migrate"));
    }

    public $message = '';
    public $messageType = '';

    public $commands = [
        'clear' => [
            'cache' => [
                'command' => 'cache:clear',
                'label' => 'Application Cache',
            ],
            'config' => [
                'command' => 'config:clear',
                'label' => 'Config Cache',
            ],
            'route' => [
                'command' => 'route:clear',
                'label' => 'Route Cache',
            ],
            'view' => [
                'command' => 'view:clear',
                'label' => 'View Cache',
            ],
            'event' => [
                'command' => 'event:clear',
                'label' => 'Event Cache',
            ],
        ],
        'cache' => [
            'config' => [
                'command' => 'config:cache',
                'label' => 'Config',
            ],
            'route' => [
                'command' => 'route:cache',
                'label' => 'Routes',
            ],
            'view' => [
                'command' => 'view:cache',
                'label' => 'Views',
            ],
            'event' => [
                'command' => 'event:cache',
                'label' => 'Events',
            ],
        ]
    ];

    public function executeCommand($command, $type = 'clear')
    {
        Artisan::call($command);

        $commandKey = explode(':', $command)[0];
        $label = $this->commands[$type][$commandKey]['label'] ?? ucfirst($commandKey);

        if ($type === 'clear') {
            $this->message = "{$label} cleared successfully!";
        } else {
            $this->message = "{$label} cached successfully!";
        }

        $this->messageType = 'success';
    }

    public function clearAll()
    {
        foreach ($this->commands['clear'] as $item) {
            Artisan::call($item['command']);
        }
        Artisan::call('optimize:clear');

        $this->message = 'All caches cleared successfully!';
        $this->messageType = 'success';
    }

    public function cacheAll()
    {
        foreach ($this->commands['cache'] as $item) {
            Artisan::call($item['command']);
        }

        $this->message = 'All items cached successfully!';
        $this->messageType = 'success';
    }

    public function optimizeApplication()
    {
        // Clear everything first
        foreach ($this->commands['clear'] as $item) {
            Artisan::call($item['command']);
        }
        Artisan::call('optimize:clear');

        // Cache everything
        foreach ($this->commands['cache'] as $item) {
            Artisan::call($item['command']);
        }

        // Run optimize
        Artisan::call('optimize');

        $this->message = 'Application fully optimized! All caches cleared and rebuilt.';
        $this->messageType = 'success';
    }
}; ?>

<div>
    <div class="grid grid-cols-12 gap-4">
        <div class="min-h-28 card col-span-3 p-3 flex justify-between items-center">
            <p class="text-2xl font-medium">
                {{ __("sync crawl request") }}
            </p>

            <form class="" action="{{route('admin.crawl_requests.sync_domains')}}" method="post">
                @csrf
                <button type="submit" class="btn btn-lg btn-primary">
                    {{ __('sync domain') }}
                </button>
            </form>
        </div>
        <div class="min-h-28 card col-span-3 p-3 flex justify-between items-center">
            <p class="text-2xl font-medium">
                {{ __("migrate database") }}
            </p>

            <button wire:click="migrateDB()" type="submit" class="btn btn-lg btn-primary">
                {{ __('migrate') }}
            </button>
        </div>
    </div>

    <div class="my-5">
        @if($message)
            <div class="alert alert-soft-{{ $messageType }} my-5">
                <div class="alert-row">
                    {{ $message }}
                </div>
            </div>
        @endif

        <!-- Clear Cache Section -->
        <div class="card p-6 mb-5">
            <h3 class="text-lg font-semibold mb-4 text-gray-900 dark:text-gray-100">
                {{ __("Clear Cache") }}
            </h3>

            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-3">
                @foreach($commands['clear'] as $key => $command)
                    <button
                        wire:click="executeCommand('{{ $command['command'] }}', 'clear')"
                        class="btn btn-secondary">

                        <span class="text-sm font-medium">{{ __($command['label']) }}</span>
                    </button>
                @endforeach
                <button
                    wire:click="clearAll"
                    class="btn btn-danger">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"/>
                    </svg>
                    {{ __("Clear All Caches") }}
                </button>
            </div>

        </div>

        <!-- Build Cache Section -->
        <div class="card p-6 mb-5">
            <h3 class="text-lg font-semibold mb-4 text-gray-900 dark:text-gray-100">
                {{ __("Build Cache") }}
            </h3>

            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-3">
                @foreach($commands['cache'] as $key => $command)
                    <button
                        wire:click="executeCommand('{{ $command['command'] }}', 'cache')"
                        class="btn btn-secondary">

                        <span class="text-sm font-medium">{{ __($command['label']) }}</span>
                    </button>
                @endforeach
                <button
                    wire:click="cacheAll"
                    class="btn btn-success">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"/>
                    </svg>
                    {{ __("Cache All") }}
                </button>
            </div>

        </div>

        <!-- Optimize Section -->
        <div class="card p-6">
            <h3 class="text-lg font-semibold mb-4 text-gray-900 dark:text-gray-100">
                {{ __("Full Optimization") }}
            </h3>

            <p class="text-sm text-gray-600 dark:text-gray-400 mb-4">
                {{ __("This will clear all caches, rebuild them, and fully optimize your application for production.") }}
            </p>

            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-3">

                <button
                    wire:click="optimizeApplication"
                    class="btn bg-gradient-to-r from-indigo-600 to-purple-600 hover:from-indigo-700 hover:to-purple-700 text-white rounded-lg transition-all duration-200 flex items-center justify-center gap-3 font-semibold text-lg shadow-lg">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                    {{ __("Optimize Application") }}
                </button>
            </div>
        </div>
    </div>
</div>
