@props([
'title' => null,
'subtitle' => null,

// visual options
'variant' => 'default', // default | compact | card | hero
'tone' => 'default', // default | soft | dark
'align' => 'start', // start | center

// optional
'icon' => null, // svg/html string or slot usage
])

@php
$variantClass = match ($variant) {
'compact' => 'page-header-compact',
'card' => 'page-header-card',
'hero' => 'page-header-hero',
default => '',
};

$toneClass = match ($tone) {
'soft' => 'page-header-soft',
'dark' => 'page-header-dark',
default => '',
};

$alignClass = $align === 'center' ? 'page-header-center' : '';

$rootClass = trim("page-header {$variantClass} {$toneClass} {$alignClass}");
@endphp

<header {{ $attributes->merge(['class' => $rootClass]) }}>
    <div class="page-header-inner">

        {{-- Breadcrumbs slot (optional) --}}
        @isset($breadcrumbs)
        <nav class="breadcrumbs">
            {{ $breadcrumbs }}
        </nav>
        @endisset

        <div class="page-header-top">
            <div class="page-header-main">
                <div class="flex items-start gap-3">
                    @isset($icon)
                    <div class="mt-1">
                        {!! $icon !!}
                    </div>
                    @endisset

                    <div class="min-w-0">
                        @if($title)
                        <h1 class="page-header-title">
                            {{ $title }}
                        </h1>
                        @endif

                        @if($subtitle)
                        <p class="page-header-subtitle">
                            {{ $subtitle }}
                        </p>
                        @endif
                    </div>
                </div>

                {{-- Meta slot (optional) --}}
                @isset($meta)
                <div class="mt-4 page-header-meta">
                    {{ $meta }}
                </div>
                @endisset
            </div>

            {{-- Actions slot (optional) --}}
            @isset($actions)
            <div class="page-header-actions">
                {{ $actions }}
            </div>
            @endisset
        </div>

        {{-- Tabs slot (optional) --}}
        @isset($tabs)
        <div class="header-tabs">
            {{ $tabs }}
        </div>
        @endisset

        {{-- Extra content slot (optional) --}}
        {{ $slot }}

    </div>
</header>
