@props(['name' , 'label' => null , 'id' => null , 'type' => 'text'  , 'value'=> null , 'placeholder' => null , 'wire' =>false])
<div {{ $attributes }}>

    <label class="text-sm font-medium" for="{{ $id ?? $name  }}">{{ $label ?? '' }}</label>

    <input id="{{ $id ?? $name }}"
           type="{{ $type }}"
           name="{{ $name }}"
           value="{{ old($name , $value) }}"
           class="w-full rounded-xl border border-slate-200 bg-slate-50 px-4 py-2 text-right outline-none focus:ring-4 focus:ring-slate-200 dark:text-black dark:focus:ring-slate-400"
           placeholder="{{ $placeholder }}"
           @if($wire)
               wire:model="{{ $name }}"
        @endif
    >


    @error($name)
    <p class="text-sm text-rose-600">{{ $message }}</p>
    @enderror
</div>
