@props([
    'defaultTab' => 'login', // 'login' | 'register'
])

<div
    x-data="{
        activeTab: @js($defaultTab),
        setTab(tabName) { this.activeTab = tabName; }
    }"
    class="w-full max-w-md mx-auto rounded-2xl border border-slate-200 bg-white p-6 md:p-8
           dark:border-slate-700 dark:bg-slate-900"
>
    <div class="flex items-center justify-between gap-2">
        <h2 class="text-xl font-semibold">
            {{ __('Account') }}
        </h2>
        <div class="text-sm text-slate-500 dark:text-slate-400">
            {{ __('Login or create an account') }}
        </div>
    </div>

    {{-- Tabs --}}
    <div
        class="mt-5 grid grid-cols-2 gap-2 p-1 rounded-xl
               bg-slate-100 dark:bg-slate-800"
    >
        <button
            type="button"
            class="py-2 rounded-lg text-sm font-medium transition"
            :class="activeTab === 'login'
                ? 'bg-white shadow-sm dark:bg-slate-900'
                : 'text-slate-600 dark:text-slate-400'"
            @click="setTab('login')"
        >
            {{ __('Login') }}
        </button>

        <button
            type="button"
            class="py-2 rounded-lg text-sm font-medium transition"
            :class="activeTab === 'register'
                ? 'bg-white shadow-sm dark:bg-slate-900'
                : 'text-slate-600 dark:text-slate-400'"
            @click="setTab('register')"
        >
            {{ __('Register') }}
        </button>
    </div>

    {{-- Login --}}
    <div class="mt-6" x-show="activeTab === 'login'" x-cloak>
        <form method="POST" action="{{ route('login') }}" class="space-y-4">
            @csrf

            <div class="space-y-2">
                <label class="text-sm font-medium" for="login_email">
                    {{ __('Email') }}
                </label>
                <input
                    id="login_email"
                    type="email"
                    name="email"
                    value="{{ old('email') }}"
                    class="w-full rounded-xl
                           border border-slate-200 bg-slate-50
                           px-4 py-3 text-right outline-none
                           focus:ring-4 focus:ring-slate-200
                           dark:border-slate-700 dark:bg-slate-800
                           dark:focus:ring-slate-700"
                    placeholder="{{ __('name@example.com') }}"
                    autocomplete="email"
                >
                @error('email')
                <p class="text-sm text-rose-600 dark:text-rose-400">{{ $message }}</p>
                @enderror
            </div>

            <div class="space-y-2">
                <label class="text-sm font-medium" for="login_password">
                    {{ __('Password') }}
                </label>
                <input
                    id="login_password"
                    type="password"
                    name="password"
                    class="w-full rounded-xl
                           border border-slate-200 bg-slate-50
                           px-4 py-3 text-right outline-none
                           focus:ring-4 focus:ring-slate-200
                           dark:border-slate-700 dark:bg-slate-800
                           dark:focus:ring-slate-700"
                    placeholder="{{ __('Your password') }}"
                    autocomplete="current-password"
                >
                @error('password')
                <p class="text-sm text-rose-600 dark:text-rose-400">{{ $message }}</p>
                @enderror
            </div>

            <div class="flex items-center justify-between text-sm">
                <label class="inline-flex items-center gap-2">
                    <input
                        type="checkbox"
                        name="remember"
                        class="rounded border-slate-300 dark:border-slate-600 dark:bg-slate-800"
                    >
                    <span class="text-slate-600 dark:text-slate-400">
                        {{ __('Remember me') }}
                    </span>
                </label>

                @if (Route::has('password.request'))
                    <a
                        href="{{ route('password.request') }}"
                        class="text-slate-700 hover:underline
                               dark:text-slate-300 dark:hover:text-slate-100"
                    >
                        {{ __('Forgot password?') }}
                    </a>
                @endif
            </div>

            <button
                type="submit"
                class="w-full rounded-xl py-3 font-medium
                       bg-slate-900 text-white hover:bg-slate-800
                       dark:bg-slate-100 dark:text-slate-900 dark:hover:bg-slate-200"
            >
                {{ __('Login') }}
            </button>
        </form>
    </div>

    {{-- Register --}}
    <div class="mt-6" x-show="activeTab === 'register'" x-cloak>
        <form method="POST" action="{{ route('register') }}" class="space-y-4">
            @csrf


            <div class="space-y-2">
                <label class="text-sm font-medium" for="register_email">
                    {{ __('Email') }}
                </label>
                <input
                    dir="ltr"
                    id="register_email"
                    type="email"
                    name="email"
                    value="{{ old('email') }}"
                    class="w-full rounded-xl
                           border border-slate-200 bg-slate-50
                           px-4 py-3  outline-none
                           focus:ring-4 focus:ring-slate-200
                           dark:border-slate-700 dark:bg-slate-800
                           dark:focus:ring-slate-700"
                    placeholder="{{ __('name@example.com') }}"
                    autocomplete="email"
                >
                @error('email')
                <p class="text-sm text-rose-600 dark:text-rose-400">{{ $message }}</p>
                @enderror
            </div>

            <div class="space-y-2">
                <label class="text-sm font-medium" for="register_password">
                    {{ __('Password') }}
                </label>
                <input
                    id="register_password"
                    type="password"
                    name="password"
                    class="w-full rounded-xl
                           border border-slate-200 bg-slate-50
                           px-4 py-3 text-right outline-none
                           focus:ring-4 focus:ring-slate-200
                           dark:border-slate-700 dark:bg-slate-800
                           dark:focus:ring-slate-700"
                    placeholder="{{ __('Choose a strong password') }}"
                    autocomplete="new-password"
                    oninput=""
                >
                @error('password')
                <p class="text-sm text-rose-600 dark:text-rose-400">{{ $message }}</p>
                @enderror
            </div>

            <div class="space-y-2">
                <label class="text-sm font-medium" for="register_password_confirmation">
                    {{ __('Confirm password') }}
                </label>
                <input
                    id="register_password_confirmation"
                    type="password"
                    name="password_confirmation"
                    class="w-full rounded-xl
                           border border-slate-200 bg-slate-50
                           px-4 py-3 text-right outline-none
                           focus:ring-4 focus:ring-slate-200
                           dark:border-slate-700 dark:bg-slate-800
                           dark:focus:ring-slate-700"
                    placeholder="{{ __('Repeat password') }}"
                    autocomplete="new-password"
                >
            </div>

            <button
                type="submit"
                class="w-full rounded-xl py-3 font-medium
                       bg-slate-900 text-white hover:bg-slate-800
                       dark:bg-slate-100 dark:text-slate-900 dark:hover:bg-slate-200"
            >
                {{ __('Create account') }}
            </button>
        </form>
    </div>
</div>
