@props(['type' => 'normal'])
<header
    class="sticky top-0 z-40
           bg-white/90 backdrop-blur
           border-b border-slate-200
           dark:bg-slate-950/80 dark:border-slate-800"
>
    <div class="{{ $type === 'normal' ? 'max-w-6xl' : '' }} mx-auto px-4">
        <div class="h-16 flex items-center justify-between gap-3">

            {{-- Logo / Brand --}}
            <a href="{{ url('/') }}" class="flex items-center gap-2">
                <div class="w-9 h-9 ">
                    <img src="{{asset('logo.png')}}">
                </div>
                <div class="leading-tight">
                    <div class="font-semibold">
                        شبکه رویان
                    </div>
                    <div class="text-xs text-slate-500 dark:text-slate-400">
                    </div>
                </div>
            </a>

            {{-- Desktop Nav (links) --}}
            <nav class="hidden md:flex items-center gap-2">
                <a href="{{ url('/') }}"
                   class="px-3 py-2 rounded-xl text-sm
                          hover:bg-slate-100
                          dark:hover:bg-slate-800">
                    {{ __('Home') }}
                </a>
                <a href="{{ route('live') }}"
                   class="px-3 py-2 rounded-xl text-sm
                          hover:bg-slate-100
                          dark:hover:bg-slate-800">
                    {{ __('Live Stream') }}
                </a>



                <a href="{{ route('contact-us') }}"
                   class="px-3 py-2 rounded-xl
                          hover:bg-slate-100
                          dark:hover:bg-slate-800">
                    {{ __('Contact Us') }}
                </a>


            </nav>

            {{-- Desktop Actions --}}
            <nav class="hidden md:flex items-center gap-2">
                @auth
                    <a
                        href="{{ auth()->user()->hasRole('admin') ? route('admin.dashboard') : route('user.dashboard') }}"
                        class="btn btn-outline-primary"
                    >
                        {{ __('Dashboard') }}
                    </a>

                    <form method="POST" action="{{ route('logout') }}" class="inline">
                        @csrf
                        <button type="submit" class="btn btn-outline-danger">
                            {{ __('Logout') }}
                        </button>
                    </form>
                @else
                    <a href="{{ route('login') }}"
                       class="px-3 py-2 rounded-xl text-sm
                              hover:bg-slate-100
                              dark:hover:bg-slate-800">
                        {{ __('Login') }}
                    </a>

                    <a href="{{ route('register') }}"
                       class="px-3 py-2 rounded-xl text-sm
                              bg-slate-900 text-white hover:bg-slate-800
                              dark:bg-slate-100 dark:text-slate-900 dark:hover:bg-slate-200">
                        {{ __('Register') }}
                    </a>
                @endauth

                {{-- Dark Mode Toggle --}}
                <button
                    @click="darkMode = !darkMode"
                    class="w-10 h-10 flex items-center justify-center
                           rounded-lg border border-slate-300
                           hover:bg-slate-100
                           dark:border-slate-700 dark:hover:bg-slate-800
                           transition-colors"
                >
                    <x-isax-linear.moon x-show="!darkMode" x-cloak/>
                    <x-isax-linear.sun-1 x-show="darkMode" x-cloak/>
                </button>
            </nav>


            {{-- Mobile Menu Button --}}
            <button
                type="button"
                class="md:hidden inline-flex items-center justify-center
                       w-10 h-10 rounded-xl
                       hover:bg-slate-100
                       dark:hover:bg-slate-800"
                @click="isMobileMenuOpen = !isMobileMenuOpen"
                :aria-expanded="isMobileMenuOpen ? 'true' : 'false'"
                aria-controls="mobile-menu">
                <span class="sr-only">{{ __('Open menu') }}</span>
                <svg class="w-6 h-6" viewBox="0 0 24 24" fill="none" stroke="currentColor">
                    <path stroke-linecap="round" stroke-width="2"
                          d="M4 7h16M4 12h16M4 17h16"/>
                </svg>
            </button>
        </div>

        {{-- Mobile Menu --}}
        <div
            id="mobile-menu"
            class="md:hidden pb-4"
            x-show="isMobileMenuOpen"
            x-cloak
        >
            <div class="pt-2 flex flex-col gap-1">


                @foreach ([
                    ['url' => url('/'), 'label' => __('Home')],
                    ['url' => route('contact-us'), 'label' => __('Contact Us')],
                ] as $item)
                    <a href="{{ $item['url'] }}"
                       class="px-3 py-2 rounded-xl
                              hover:bg-slate-100
                              dark:hover:bg-slate-800">
                        {{ $item['label'] }}
                    </a>
                @endforeach

                @auth
                    <a
                        href="{{ auth()->user()->hasRole('admin') ? route('admin.dashboard') : route('user.dashboard') }}"
                        class="btn btn-outline-primary btn-block"
                    >
                        {{ __('Dashboard') }}
                    </a>

                    <form method="POST" action="{{ route('logout') }}">
                        @csrf
                        <button
                            type="submit"
                            class="btn btn-outline-danger btn-block"
                        >
                            {{ __('Logout') }}
                        </button>
                    </form>
                @else
                    <a href="{{ route('login') }}"
                       class="px-3 py-2 rounded-xl
                              hover:bg-slate-100
                              dark:hover:bg-slate-800">
                        {{ __('Login') }}
                    </a>

                    <a href="{{ route('register') }}"
                       class="px-3 py-2 rounded-xl
                              bg-slate-900 text-white hover:bg-slate-800
                              dark:bg-slate-100 dark:text-slate-900 dark:hover:bg-slate-200">
                        {{ __('Register') }}
                    </a>
                @endauth

                <div class="w-full border-t border-t-slate-200 dark:border-t-slate-600 pt-2 mt-2 flex justify-end ">
                    {{-- Dark Mode Toggle --}}
                    <button
                        @click="darkMode = !darkMode"
                        class="md:hidden inline-flex w-10 h-10  items-center justify-center
                           rounded-lg border border-slate-300
                           hover:bg-slate-100
                           dark:border-slate-700 dark:hover:bg-slate-800
                           transition-colors">
                        <x-isax-linear.moon x-show="!darkMode" x-cloak/>
                        <x-isax-linear.sun-1 x-show="darkMode" x-cloak/>
                    </button>
                </div>

            </div>
        </div>
    </div>
</header>
