@props([
    'title' => 'TvRoyan',
    'description' => __('Search across indexed domains'),
    'header' => true,
    'headerType' => null,
    'footer' => true,
    'mainClass' => null,
    'style' => null,
    'script' => null,
])

    <!Doctype html>
<html lang="{{ str_replace('_', '-', app()->getLocale()) }}" dir="rtl">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <title>{{ $title }}</title>
    <meta name="description" content="{{ $description }}">

    {!! $style ?? '' !!}

    <script>
        (function () {
            try {
                const saved = localStorage.getItem('darkMode');
                if (
                    saved === 'true' ||
                    (saved === null && window.matchMedia('(prefers-color-scheme: dark)').matches)
                ) {
                    document.documentElement.classList.add('dark');
                }
            } catch (e) {
            }
        })();
    </script>

    <style>
        [x-cloak] {
            display: none !important;
        }
    </style>

    @vite(['resources/css/app.css', 'resources/js/app.js'])

</head>

<body class="min-h-screen bg-slate-50 text-slate-900 dark:bg-slate-950 dark:text-slate-50" x-data="{darkMode: false}">

<div class="min-h-screen flex flex-col" x-data="bodyInitializer">

    @if($header)
        <x-layouts.header :type="$headerType"/>
    @endif

    <main class="h-full flex-1 dark:bg-slate-950 dark:text-slate-50 {{ $mainClass ?? '' }}">
        {{ $slot }}
    </main>

    @if($footer)
        <x-layouts.footer/>
    @endif


    {!! $script ?? '' !!}
</div>

</body>

</html>
