@props(['user' => null])

@php
    $isEdit = $user !== null ? true : false;
@endphp

<div>
    <form action="{{ $isEdit ? route('admin.users.update' , $user->id) : route('admin.users.store') }}" method="POST">
        @if($isEdit)
            @method('PATCH')
        @endif

        @csrf

        @session('success')
        <div class="p-3 bg-green-200 border border-green-400 text-green-800 rounded-xl shadow  ">
            {{ session('success') }}
        </div>
        @endsession

        <div class="mb-5">
            <x-ui.form.input class="mb-3" name="name" label="{{ __('Name') }}" value="{{ $user->name ?? '' }}"/>
            <x-ui.form.input class="mb-3" name="email" type="email" label="{{ __('Email') }}" value="{{ $user->email ?? '' }}"/>
            <x-ui.form.input class="mb-3" name="password" type="password" label="{{ __('Password') }}"/>
        </div>
        <div>
            <button class="w-full rounded-xl bg-slate-900 text-white py-3 hover:bg-slate-800">
                {{ $isEdit ? __('Update') : __('Create') }}
            </button>
        </div>
    </form>
</div>
