@props([
    'profile' => []
])

<div class="w-full max-w-sm rounded-3xl border border-gray-200 bg-white shadow-sm overflow-hidden
            dark:border-white/10 dark:bg-zinc-900">

    {{-- Cover --}}
    <div class="h-28 bg-gradient-to-r from-indigo-500 to-purple-500 relative">
        @if(!empty($profile['cover_src']))
            <img
                src="{{ $profile['cover_src'] }}"
                alt="Cover"
                class="absolute inset-0 h-full w-full object-cover"
            >
        @endif
    </div>

    {{-- Avatar --}}
    <div class="relative px-6">
        <div class="-mt-14 flex justify-center">
            <img
                src="{{ $profile['pic_m'] ?? $profile['pic_s'] }}"
                alt="{{ $profile['name'] }}"
                class="h-28 w-28 rounded-full border-4 border-white object-cover
                       dark:border-zinc-900"
            >
        </div>
    </div>

    {{-- Content --}}
    <div class="px-6 pb-6 pt-3 text-center">
        <h3 class="text-lg font-bold text-gray-900 dark:text-white">
            {{ $profile['name'] }}
        </h3>

        <p class="mt-1 text-sm text-gray-500 dark:text-gray-400" dir="ltr">
            {{ '@'.$profile['username'] }}
        </p>

        @if(!empty($profile['descr']))
            <a
                href="{{ $profile['descr'] }}"
                target="_blank"
                class="mt-2 block text-sm text-indigo-600 hover:underline dark:text-indigo-400"
            >
                {{ $profile['descr'] }}
            </a>
        @endif

        {{-- Stats --}}
        <div class="mt-4 grid grid-cols-3 gap-3 text-center">
            <div>
                <p class="text-lg font-semibold text-gray-900 dark:text-white">
                    {{ $profile['video_cnt'] ?: 0 }}
                </p>
                <p class="text-xs text-gray-500 dark:text-gray-400">Videos</p>
            </div>
            <div>
                <p class="text-lg font-semibold text-gray-900 dark:text-white">
                    {{ $profile['follower_cnt'] ?: 0 }}
                </p>
                <p class="text-xs text-gray-500 dark:text-gray-400">Followers</p>
            </div>
            <div>
                <p class="text-lg font-semibold text-gray-900 dark:text-white">
                    {{ $profile['followed_cnt'] ?: 0 }}
                </p>
                <p class="text-xs text-gray-500 dark:text-gray-400">Following</p>
            </div>
        </div>

        {{-- Actions --}}
        <div class="mt-5 flex gap-3">
            <a
                href="{{ $profile['url'] ?: "https://www.aparat.com/".$profile['username'] ?: '#' }}"
                class="flex-1 rounded-xl bg-indigo-600 px-4 py-2 text-sm font-semibold text-white
                       hover:bg-indigo-700 transition"
                target="_blank"
            >
                View Profile
            </a>

            @if($profile['has_live'] === 'yes')
                <span
                    class="flex items-center justify-center rounded-xl border border-red-500 px-4 py-2
                           text-sm font-semibold text-red-500"
                >
                    🔴 Live
                </span>
            @endif
        </div>
    </div>
</div>
