@props([
'active' => null, // optional: 'dashboard' | 'users' | 'contact' | 'crawl' | 'domains' | 'token'
'title' => null,
])

<nav {{ $attributes->merge(['class' => 'w-full']) }}>
    <div class="w-full flex flex-col sm:flex-row sm:items-center sm:justify-between gap-3">



        {{-- Right: menu --}}
        <div class="flex flex-wrap gap-2">
            @hasrole('admin')
            <x-admin.top-nav-link :active="$active === 'dashboard'" :href="route('admin.dashboard')">
                {{ __('Dashboard') }}
            </x-admin.top-nav-link>
            <x-admin.top-nav-link :active="$active === 'users'" :href="route('admin.users.index')">
                {{ __('Users') }}
            </x-admin.top-nav-link>

            <x-admin.top-nav-link :active="$active === 'contact'" :href="route('admin.contact-us-submissions')">
                {{ __('Contact Form Responses') }}
            </x-admin.top-nav-link>
            <x-admin.top-nav-link :active="$active === 'settings'" :href="route('admin.settings')">
                {{ __('settings') }}
            </x-admin.top-nav-link>
            <x-admin.top-nav-link :active="$active === 'ui'" :href="route('admin.ui.index')">
                {{ __('ui') }}
            </x-admin.top-nav-link>
            @endhasrole
            @hasrole('client')
            <x-admin.top-nav-link :active="$active === 'dashboard'" :href="route('user.dashboard')">
                {{ __('Dashboard') }}
            </x-admin.top-nav-link>

            @endhasrole
        </div>

        {{-- Left: title / breadcrumb slot --}}
        <div class="flex items-center justify-between">
            <div class="text-base font-semibold text-slate-900 dark:text-white">
                {{ $title ?? __('Dashboard') }}
            </div>
        </div>
    </div>
</nav>
