@props([
    'href',
    'active' => false,
])

<a href="{{ $href }}"
    @class([
         'inline-flex items-center rounded-xl px-4 py-2 text-sm font-medium transition',
         'bg-slate-900 text-white
          dark:bg-slate-100 dark:text-slate-900' => $active,

         'bg-slate-100 text-slate-800 hover:bg-slate-200
          dark:bg-slate-800 dark:text-slate-200 dark:hover:bg-slate-700' => ! $active,
    ])>
    {{ $slot }}
</a>
