import './bootstrap';
import {Livewire, Alpine} from '../../vendor/livewire/livewire/dist/livewire.esm';
import Clipboard from '@ryangjchandler/alpine-clipboard'
import $ from 'jquery';
import 'flowbite';
import Swal from 'sweetalert2'

import './alpine-main.js'


// dark mode check
window.$ = window.jQuery = $;
window.Swal = Swal;


Alpine.plugin(Clipboard)
Livewire.start()


document.addEventListener('DOMContentLoaded', function () {
    const categoryHeaders = document.querySelectorAll('.category-header');

    categoryHeaders.forEach(header => {
        header.addEventListener('click', function () {
            const category = this.getAttribute('data-category');
            const content = document.getElementById(`content-${category}`);
            const icon = document.getElementById(`icon-${category}`);

            content.classList.toggle('active');
            icon.classList.toggle('rotate-icon');
        });
    });


    const darkModeToggle = document.querySelector('[data-action="dark-mode"]');
    if (darkModeToggle) {
        darkModeToggle.addEventListener('click', function () {
            document.documentElement.classList.toggle('dark');
            localStorage.setItem('darkMode', document.documentElement.classList.contains('dark'));
        });
    }
    if (localStorage.getItem('darkMode') === 'true') {
        document.documentElement.classList.add('dark');
    }

});
