document.addEventListener('alpine:init', () => {
    Alpine.data('bodyInitializer', () => (
        {
            darkMode: false,
            sidebarOpen: false,
            isMobileMenuOpen: false,

            async init() {
                this.darkMode = localStorage.getItem('darkMode') === 'true';
                this.$watch('darkMode', val => {
                    localStorage.setItem('darkMode', val);
                    if (val) {
                        document.documentElement.classList.add('dark');
                    } else {
                        document.documentElement.classList.remove('dark');
                    }
                });
                if (this.darkMode) {
                    document.documentElement.classList.add('dark');
                }


                await this.live.refresh();
                // refresh live status every 30s
                setInterval(() => this.live.refresh(), 30000);
            },


            liveEmbed: {
                provider: "aparat", // "aparat" | "youtube"
                src: "https://www.aparat.com/embed/live/tvroyan",
            },

            live: {
                isLive: false,
                title: "Royan Live",
                host: "Royan Team",
                viewers: 0,
                startedAt: null,
                lastCheckedAt: null,
                // Later: you can fetch real live status from your backend
                async refresh() {
                    // DEMO behavior: toggles based on schedule window or random
                    // Replace with: const res = await fetch('/api/live-status'); ...
                    const now = new Date();
                    this.lastCheckedAt = now.toISOString();

                    // Simple heuristic: if current time is between 18:00–22:00, mark live
                    const hour = now.getHours();
                    const shouldBeLive = hour >= 18 && hour <= 22;

                    if (shouldBeLive && !this.isLive) {
                        this.isLive = true;
                        this.startedAt = now.toISOString();
                        this.viewers = 20 + Math.floor(Math.random() * 80);
                    } else if (!shouldBeLive && this.isLive) {
                        this.isLive = false;
                        this.viewers = 0;
                    } else if (this.isLive) {
                        // fluctuate
                        this.viewers = Math.max(1, this.viewers + (-5 + Math.floor(Math.random() * 11)));
                    }
                },
            },



        }
    ));


    // Alpine.data('livePageInitializer' , () => ());
});
