<?php

namespace App\Services;

use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;


/**
 *
 * base on https://www.aparat.com/api
 */

class AparatService
{

    private const BASE_URL = 'https://www.aparat.com//etc/api/{action}/{parameters}';

    protected $requestUrl;
    protected $action;
    protected $parameters;


    public function  __construct()
    {
        $this->requestUrl = self::BASE_URL;
    }
    public function action(string $action): static
    {
        $this->action = $action;
        return $this;
    }
    public function parameters(array $parameters): static
    {
        $parametersString = "";

        foreach ($parameters as $key => $value) {
            $parametersString .= "$key/$value/";
        }

        $this->parameters = $parametersString;
        return $this;
    }
    public function generateUrl(): static
    {
        $this->requestUrl = Str::replace('{action}', $this->action, $this->requestUrl);
        $this->requestUrl = Str::replace('{parameters}', $this->parameters, $this->requestUrl);
        return $this;
    }
    public function sendRequest($method = 'post')
    {
        $response = Http::$method($this->requestUrl);

        return $response;
    }


    /// data method


    public function login($username, $password)
    {
        return $this->action('login')
            ->parameters([
                'luser' => $username,
                'lpass' => sha1(md5($password)),
            ])
            ->generateUrl()
            ->sendRequest(method: 'post');
    }
    public function getProfile($username)
    {
        return $this->action('profile')
            ->parameters(['username' => $username])
            ->generateUrl()
            ->sendRequest(method: 'get');
    }
    public function getProfileCategories($username)
    {
        return $this->action('profilecategories')
            ->parameters(['username' => $username])
            ->generateUrl()
            ->sendRequest(method: 'get');
    }
    public function getUserVideos($username, $perpage = 10)
    {
        return $this->action('videoByUser')
            ->parameters([
                'username' => $username,
                'perpage' => $perpage,
            ])
            ->generateUrl()
            ->sendRequest(method: 'get');
    }
    public function getSingleVideo($videoHash)
    {
        return $this->action('video')
            ->parameters([
                'videohash' => $videoHash,
            ])
            ->generateUrl()
            ->sendRequest(method: 'get');
    }
    public function getCommentForVideo($videoHash, $perpage = 10)
    {
        return $this->action('commentByVideos')
            ->parameters([
                'videohash' => $videoHash,
                'perpage' => $perpage,
            ])
            ->generateUrl()
            ->sendRequest(method: 'get');
    }
    public function uploadForm($username, $token)
    {
        return $this->action('uploadform')
            ->parameters([
                'luser' => $username,
                'ltoken' => $token,
            ])
            ->generateUrl()
            ->sendRequest(method: 'get');
    }
    public function getCategories()
    {
        return $this->action('categories')
            ->parameters([])
            ->generateUrl()
            ->sendRequest(method: 'get');
    }


}
