<?php

namespace App\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Response;

class MacroServiceProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        /**
         * the api response already have an status code that will be equal to $status so let the status inside
         * the data property be as boolean value
         */
        if (!Response::hasMacro('api')) {
            Response::macro('api', function (mixed $data, ?string $message = null, int $status = 200) {
                return Response::json([
                    'status' => $status < 300,
                    'message' => $message ?? __('api.success'),
                    'data' => $data,
                ], $status);
            });
        }

        if (!Response::hasMacro('success')) {
            Response::macro('success', function (mixed $data = null, ?string $message = null, int $status = 200) {
                return Response::api($data, $message ?? __('api.success'), $status);
            });
        }

        if (!Response::hasMacro('failure')) {
            Response::macro('failure', function (mixed $data = null, ?string $message = null, int $status = 500) {
                return Response::api($data, $message ?? __('api.request_failed'), $status);
            });
        }
    }
}
