<?php

namespace App\Providers;

use Illuminate\Support\Facades\Gate;
use App\Services\Models\SettingService;
use Illuminate\Support\ServiceProvider;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        $this->app->singleton('settings', function () {
            return new SettingService('web');
        });

        Gate::before(function ($user, $ability) {
            return $user->hasRole('administrator') ? true : null;
        });
    }
}
