<?php

namespace App\Models;

// use Illuminate\Contracts\Auth\MustVerifyEmail;
use App\Services\AparatService;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Spatie\Permission\Traits\HasPermissions;
use Spatie\Permission\Traits\HasRoles;

class User extends Authenticatable
{
    use HasFactory, Notifiable, HasRoles, HasPermissions;

    /**
     * The attributes that are mass assignable.
     *
     * @var list<string>
     */
    protected $fillable = [
        'name',
        'username',
        'email',
        'phone',
        'password',

        'status',
        'aparat_username',
        'aparat_profile',
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var list<string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'phone_verified_at' => 'datetime',
            'password' => 'hashed',
            'aparat_profile' => 'array',
        ];
    }


    public function updateApartProfile(): bool
    {
        if ($this->aparat_username === null) return false;

        $profile = (new AparatService)->getProfile($this->aparat_username)->json();

        if (!isset($profile['profile'])) return false;

        $this->aparat_profile = $profile['profile'];

        $this->status = 'active';
        $this->save();
        return true;
    }

    public function isActive()
    {
        return $this->status === 'active';
    }
    public function hasAparatProfile()
    {
        return $this->aparat_profile !== null;
    }
}
