<?php

namespace App\Models;

use Illuminate\Support\Collection;
use Illuminate\Database\Eloquent\Model;

class Setting extends Model
{
    protected $fillable = [
        'env',
        'group',
        'key',
        'value',
        'data',
    ];

    public $casts = [
        'data' => 'array',
    ];

    public static function getByKey(string $key, $first = false): Collection|null
    {
        if ($first === true) {
            return app('web_options')->where('key', $key)->first();
        }
        return app('web_options')->where('key', $key)->values();
    }

    public static function getValue(string $key, $default = null)
    {
        return optional(static::getByKey($key)->first())->value ?? $default;
    }

    public function scopeWeb($query)
    {
        return $query->where('env', 'web');
    }

    public function scopeEnv($query, $env)
    {
        return $query->where('env', $env);
    }

    public function scopeKey($query, $key)
    {
        return $query->where('key', $key);
    }
}
