<?php

namespace App\Http\Middleware\Api;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Cache;
use Illuminate\Support\Facades\Hash;
use Symfony\Component\HttpFoundation\Response;
use Illuminate\Support\Facades\Response as FacadeResponse;

class ScriptAuthMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response) $next
     */
    public function handle(Request $request, Closure $next): Response
    {
        if ($request->headers->has('secret') && Hash::check($request->headers->get('secret'), Cache::get('script-token'))) {
            return $next($request);
        } else
            return FacadeResponse::api([
                'header-secret' => $request->headers->get('secret'),
                'cache-key' => Cache::get('script-token'),
                'check' => Hash::check($request->headers->get('secret'), Cache::get('script-token'))

            ], 'unauthorized', Response::HTTP_UNAUTHORIZED);
    }
}
