<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class HomePageController extends Controller
{
    public function index(Request $request)
    {
        // Social + Channels links
        $links = [
            'instagram' => 'https://instagram.com/tvroyan',
            'telegram' => 'https://t.me/tvroyan',
            'discord' => 'https://discord.gg/xxxxxx',
            'aparat' => 'https://aparat.com/tvroyan',
            'youtube' => 'https://youtube.com/@tvroyan',
        ];

        // Live status last checked timestamp (server-side)
        // You can replace this with a DB value or cache value later
        $liveLastCheckedAt = now()->format('Y-m-d H:i');

        // Weekly schedule (server-rendered)
        $scheduleDays = [
            [
                'name' => __('Saturday'),
                'items' => [
                    ['time' => '18:00', 'title' => __('Laravel Live Coding'), 'host' => __('Hadi')],
                    ['time' => '20:00', 'title' => __('3D Modeling Session'), 'host' => __('Alireza')],
                ],
            ],
            [
                'name' => __('Sunday'),
                'items' => [
                    ['time' => '19:00', 'title' => __('Project Build Night'), 'host' => __('Hadi')],
                ],
            ],
            [
                'name' => __('Monday'),
                'items' => [],
            ],
            [
                'name' => __('Tuesday'),
                'items' => [
                    ['time' => '21:00', 'title' => __('UI/UX + Tailwind Workshop'), 'host' => __('Alireza')],
                ],
            ],
            [
                'name' => __('Wednesday'),
                'items' => [],
            ],
            [
                'name' => __('Thursday'),
                'items' => [
                    ['time' => '20:30', 'title' => __('Coding + Q&A'), 'host' => __('Hadi')],
                ],
            ],
            [
                'name' => __('Friday'),
                'items' => [
                    ['time' => '18:30', 'title' => __('Weekly Recap'), 'host' => __('Alireza')],
                ],
            ],
        ];

        // Team members (server-rendered)
        $team = [
            [
                'name' => 'Alireza Hadizadeh',
                'role' => __('Programmer'),
                'bio' => __("Hi, I'm Alireza – a full-stack developer passionate about building apps and sharing my journey in development and beyond."),
                'initial' => 'AH',
            ],
            [
                'name' => 'Mohammad Hossein Samii',
                'role' => __('3D designer'),
                'bio' => '',
                'initial' => 'MH',
            ],
            // Add more members here...
        ];
        $scheduleDays = [];
        $links = [];
        return view('pages.index', compact(
            'links',
            'scheduleDays',
            'team',
            'liveLastCheckedAt'
        ));
    }
}
