<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Auth\Events\Registered;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class RegisterController extends Controller
{
    public function register(Request $request)
    {
        $validated = $request->validate([
            'email' => 'required|unique:users',
            'password' => 'required|min:8|confirmed'
        ]);

        $validated['status'] = 'pending';
        $user = User::create($validated);

        event(new Registered($user));

        $user->assignRole('client');

        Auth::login($user);

        return redirect()->intended('/');

    }
}
