<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;

class LoginController extends Controller
{
    public function login(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            'password' => 'required'
        ]);

        $user = User::where('email', $request->email)->first();

        if ($user === null) {
            return back()->with('error', __("user not found"));
        }

        if (!Hash::check($request->password, $user->password)) {
            return back()->with('error', __('auth.failed'));
        }

        Auth::login($user);

        return redirect()->intended('/');
    }
}
