Sure! Below are the full Laravel migration files for all the required tables. You can copy each block into separate files in your `database/migrations` directory. The timestamp (`2025_06_21_161026`) is placeholder text — Laravel will generate actual filenames when you run `php artisan make:migration`.

---

### 🟦 1. `create_pages_table.php`

```php
Schema::create('pages', function (Blueprint $table) {
    $table->id();
    $table->string('url')->unique();
    $table->string('domain')->index();
    $table->string('title')->nullable();
    $table->text('description')->nullable();
    $table->longText('content')->nullable();
    $table->text('keywords')->nullable();
    $table->longText('html')->nullable();
    $table->string('language', 10)->nullable();
    $table->string('content_type')->nullable();
    $table->timestamp('crawled_at')->nullable();
    $table->timestamps();
});
```

---

### 🟦 2. `create_images_table.php`

```php
Schema::create('images', function (Blueprint $table) {
    $table->id();
    $table->foreignId('page_id')->constrained()->onDelete('cascade');
    $table->text('src');
    $table->text('alt')->nullable();
    $table->text('title')->nullable();
    $table->integer('width')->nullable();
    $table->integer('height')->nullable();
    $table->string('mime')->nullable();
    $table->timestamps();
});
```

---

### 🟦 3. `create_videos_table.php`

```php
Schema::create('videos', function (Blueprint $table) {
    $table->id();
    $table->foreignId('page_id')->constrained()->onDelete('cascade');
    $table->text('src');
    $table->text('title')->nullable();
    $table->integer('duration')->nullable();
    $table->string('type')->nullable(); // e.g., youtube, mp4
    $table->timestamps();
});
```

---

### 🟦 4. `create_links_table.php`

```php
Schema::create('links', function (Blueprint $table) {
    $table->id();
    $table->foreignId('from_page_id')->constrained('pages')->onDelete('cascade');
    $table->text('to_url');
    $table->text('anchor_text')->nullable();
    $table->boolean('is_internal')->default(true);
    $table->timestamps();
});
```

---

### 🟦 5. `create_search_logs_table.php`

```php
Schema::create('search_logs', function (Blueprint $table) {
    $table->id();
    $table->string('query');
    $table->string('ip_address')->nullable();
    $table->text('user_agent')->nullable();
    $table->foreignId('clicked_page_id')->nullable()->constrained('pages')->onDelete('set null');
    $table->timestamps();
});
```

---

### 🟦 6. `create_domains_table.php`

```php
Schema::create('domains', function (Blueprint $table) {
    $table->id();
    $table->string('name')->unique();
    $table->string('robots_txt_status')->nullable(); // allowed / disallowed
    $table->string('crawl_priority')->default('normal'); // low, normal, high
    $table->timestamp('last_crawled_at')->nullable();
    $table->timestamps();
});
```

---

### 🟦 7. `create_page_ranks_table.php`

```php
Schema::create('page_ranks', function (Blueprint $table) {
    $table->id();
    $table->foreignId('page_id')->constrained()->onDelete('cascade');
    $table->float('score')->default(0);
    $table->string('method')->default('pagerank'); // pagerank, tf-idf, embedding, etc.
    $table->timestamps();
});
```

---

### 🟦 8. `create_snapshots_table.php`

```php
Schema::create('snapshots', function (Blueprint $table) {
    $table->id();
    $table->foreignId('page_id')->constrained()->onDelete('cascade');
    $table->longText('html');
    $table->timestamp('snapshot_at');
    $table->timestamps();
});
```

---

Let me know if you'd like:

* Eloquent model definitions for these tables
* Example seeder scripts
* A sample search frontend in Laravel
* The Python crawler that sends data to your Laravel backend via API

Ready for the next step?
